# iTop-CVEs-exploit
This repository contains exploits for iTOP CVE-2024-52002, 52000, 31998, 31448 that involve CSRF+XSS chaining to get admin privileges on the software.

## Set up
1) Download the vulnerable iTOP version from docker
```
sudo docker run -d -p 8090:80 --name=my-itop2 vbkunin/itop:3.1.1 
```
2) Navigate to localhost:8090 and perform the standard installation
3) Use the command below to get the password
```
sudo docker logs my-itop2 | grep -A7 -B1 "Your MySQL user 'admin' has password"
```
![image](https://github.com/user-attachments/assets/5fda0782-1d06-4dd0-b6fd-20b82f22ba32)
It should look something like this

4) Now continue with standard installation steps
5) This will conclude the set up phase and now you can enter iTOP
![image](https://github.com/user-attachments/assets/2d1028d2-ed82-40a4-902e-16a9c12afc0e)


## Exploitation

Feel free to explore the iTOP software.

As an attacker the most valuable thing would be to get access to the software remotely via admin login located at `http://localhost:8090/pages/UI.php?c%5Bmenu%5D=UserAccountsMenu`

### XSS
Let's start by testing XSS exploit, you can use the xss.csv in this github repo to test this.
1) Navigate to `http://localhost:8090/pages/csvimport.php?c%5Bmenu%5D=CSVImport`
2) Click on `Select a File` and upload the xss.csv
3) Continue with standard options till Step 3
4) On Step 3 select Person as the import type
![image](https://github.com/user-attachments/assets/cf4071e4-3792-4f98-ba23-e9b2155c7ea1)
5) Clicking on `Simulate the import` we can see the XSS
![image](https://github.com/user-attachments/assets/770a665c-0284-4626-b83b-7bef7b9cb430)
6) This proves the presence of XSS.
7) This alone doesn't have a lot of value we will come back to this.

### CSRF
Let's explore CSRF as the CVE pages tell us that there are CSRF on multiple pages.
Both CSRF & XSS alone don't give us much but together we could do something to eventually create an admin account.
1) Let's perform a simple test, looking at burpsuite for all the parameters, we will create a simple test html file and host it on python server. (`first_step_import_data.html`)
`python3 -m http.server 9001`
2) This file exploits the CSRF and XSS from above to alert us with the CSRF token required to complete the import task.
3) We explored that this token is not tied to any action, so we receive this token, we can make the user complete some other operation by getting the token from XSS vulnerable page.
4) When you host the html file above and click on it as a logged in user, you will see that the token is alerted in the browser.
5) We shall now tweak this exploit to call our server with the token which will be then chained to the other part of the exploit where it will be used to create a user.
`first_step_add_user.html` and `last_step_add_user.html`

![image](https://github.com/user-attachments/assets/ed16ff8c-4a87-4292-b78d-5ec46cbd3886)

We can see that when user clicks on the link `first_step_add_user.html` it first uses the CSRF+XSS to get the action token and then uses that to create the user by chaining.
Essentially it becomes CSRF+XSS+CSRF

The vulnerable link can be sent to the user using a sample phishing email added in the github repo.


## References
- https://nvd.nist.gov/vuln/detail/cve-2024-52002
- https://nvd.nist.gov/vuln/detail/cve-2024-52000
- https://nvd.nist.gov/vuln/detail/CVE-2024-31998
- https://nvd.nist.gov/vuln/detail/CVE-2024-31448
- https://owasp.org/www-community/HttpOnly
- https://bugbase.ai/blog/how-to-bypass-csrf-protection
- https://medium.com/sessionstack-blog/how-javascript-works-5-types-of-xss-attacks-tips-on-preventing-them-e6e28327748a
- https://www.sitepoint.com/get-url-parameters-with-javascript/
- https://portswigger.net/web-security/csrf#how-to-construct-a-csrf-attack
- https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS
