# ⚠️ CVE-2024-51996 - Symfony RememberMe Auth Bypass Exploit

Exploit para la vulnerabilidad crítica **CVE-2024-51996**, que permite el **bypass de autenticación** en aplicaciones Symfony que utilizan el mecanismo `Remember Me`.

> 🧠 **Impacto**: Suplantación de usuarios privilegiados (como `admin`) sin necesidad de credenciales válidas.

---

## 📖 Descripción

**CVE-2024-51996** es una vulnerabilidad en el componente `security-http` de Symfony. El fallo radica en que **no se valida correctamente el nombre de usuario** contenido en la cookie `REMEMBERME`, lo que permite modificarlo sin invalidar el token.

Un atacante con acceso a una cookie válida (por ejemplo, `User1:token:series:hash`) puede modificarla y reemplazar el identificador `User1` por cualquier otro nombre de usuario registrado, como `admin`.

---

## 🚀 Uso del Exploit

```bash
python3 CVE-2024-51996_Exploit.py \
  --url https://objetivo.com \
  --cookie "User1:token:series:hash" \
  --spoof admin
```

  ---


## 🙌 Apóyame

Si esta herramienta te ha sido útil o quieres apoyar futuros desarrollos, puedes invitarme un café ☕ o hacer una donación. ¡Cualquier apoyo cuenta!

[![Donate with PayPal](https://img.shields.io/badge/PayPal-Donate-blue.svg)](https://www.paypal.com/paypalme/moften)

---

## 📬 Contacto y redes

- 💌 Correo: [m10sec@proton.me](mailto:m10sec@proton.me)
- 🌐 Blog: [https://m10.com.mx](https://m10.com.mx)
- 🐦 Twitter: [@hack4lifemx](https://twitter.com/hack4lifemx)
- 💼 LinkedIn: [Francisco Santibañez](https://www.linkedin.com/in/franciscosantibanez)
- 🐙 GitHub: [github.com/m10sec](https://github.com/moften)

---

## 🛡️ Filosofía

Creo en un mundo donde los usuarios tienen control sobre su privacidad. Esta herramienta nace desde la trinchera del pentesting real, con amor por la libertad digital y el hacking con propósito.

---

⭐ Si te gustó este proyecto, dale una estrella en GitHub y compártelo con tu comunidad.