# 💀 CVE-2024-51788 - WordPress The Novel Design Store Directory Plugin <= 4.3.0 - Unauthenticated Arbitrary File Upload

## 🚨 Overview
**CVE-2024-51788** is a newly disclosed **critical** vulnerability affecting the **The Novel Design Store Directory** WordPress plugin (**<= v4.3.0**). This flaw allows **unauthenticated attackers** to upload arbitrary files, including **malicious web shells**, leading to **Remote Code Execution (RCE)** on the affected server.

🔴 **Severity:** 10.0 / 10 (Critical)  
📅 **Published:** November 11, 2024  
📅 **Updated:** November 12, 2024  
🔗 **CWE ID:** [CWE-434 - Unrestricted File Upload](https://cwe.mitre.org/data/definitions/434.html)  

---
## 🛑 Impact
✅ **Full server compromise** - Attackers can gain complete control over the website and execute arbitrary commands.  
✅ **Data Breach** - Access and modification of sensitive information.  
✅ **Website defacement & malware injection** - Attackers can modify website content or plant malware.  
✅ **Privilege escalation** - Attackers may exploit this to escalate privileges and move laterally within the network.  

---
## ⚡ Exploit Details
The vulnerability exists due to **improper validation** of uploaded files in the **wp-admin/options-general.php?page=licence** endpoint. Attackers can upload **malicious PHP scripts** into the **/wp-content/plugins/noveldesign-store-directory/images/** directory without authentication, ultimately leading to **Remote Code Execution (RCE)**.

🚨 **Key factors enabling the attack:**
- No authentication required.
- Unrestricted file upload.
- The uploaded files are directly executable.

### 🛠️ Exploit Script Overview
A Python-based exploit script has been developed to automate the exploitation process. This script:

✅ **Bypasses authentication** using random user agents & cookies.  
✅ **Uploads a malicious PHP shell** directly to the server.  
✅ **Executes arbitrary commands** on the compromised machine.  
✅ **Automatically detects if the target is vulnerable.**  

📌 **Exploit Usage:**
```bash

usage: CVE-2024-51788.py [-h] -u URL

Exploit script for CVE-2024-51788 # by Nxploit Khaled Alenazi.

options:
  -h, --help     show this help message and exit
  -u, --url URL  Target URL


```
🔍 If successful, the shell will be uploaded to:
```
/wp-content/plugins/noveldesign-store-directory/images/
```

---
## 🚀 Exploitation Steps
1️⃣ **Clone the repository:**  
```bash
git clone https://github.com/Nxploit/CVE-2024-51788.git
cd CVE-2024-51788
```
2️⃣ **Run the exploit script:**  
```bash
python3 CVE-2024-51788.py -u http://target-wordpress-site.com
```
3️⃣ **Access the uploaded shell:**  
```bash
http://target-wordpress-site.com/wp-content/plugins/noveldesign-store-directory/images/shell.php
```
### To ensure the exploit script runs smoothly, install the required dependencies using the following command: 

```
pip install requests argparse urllib3

```
---
## 🛡️ Mitigation & Fixes
🔹 **Update to the latest version** of The Novel Design Store Directory plugin.  
🔹 **Restrict file upload permissions** to allow only safe file types.  

  


---
## 📝 Disclaimer
⚠️ **This exploit is for educational and research purposes only.** Unauthorized use of this exploit against systems without proper authorization is **illegal**. The author is not responsible for any misuse of this information.

---
## 🔗 References
- [NVD CVE-2024-51788](https://nvd.nist.gov/vuln/detail/CVE-2024-51788)  
- [Patchstack Advisory](https://patchstack.com/database/vulnerability/noveldesign-store-directory)  

---
📌
    **_By: Nxploit | Khaled Alenazi_** | 🔥 Follow for more security research and exploits!
 
