# CVE-2024-51567 Exploit Script

**CVE-2024-51567** is a Python proof-of-concept (PoC) exploit script for **CVE-2024-51567**, a critical command injection vulnerability affecting CyberPanel v2.3.6. This vulnerability, found in the `upgrademysqlstatus` endpoint, enables remote command execution (RCE) by bypassing CSRF protections and utilizing shell metacharacters in specific parameters.

> **⚠️ Important Disclaimer**: This script is intended for educational purposes and authorized security testing on systems you own or have explicit permission to test. Unauthorized use of this script on any system is illegal and punishable by law. The author assumes no responsibility for misuse. Always adhere to ethical standards and applicable laws.

# Table of Contents
- [Vulnerability Overview](#vulnerability-overview)
- [Features](#features)
- [Prerequisites](#prerequisites)
- [Installation](#installation)
- [Usage](#usage)
  - [Single Target](#single-target)
  - [Multiple Targets](#multiple-targets)
  - [Example: Multiple Targets](#example-multiple-targets)
  - [Sample Output](#sample-output)
- [Code Structure](#code-structure)
- [Error Handling and Debugging](#error-handling-and-debugging)
  - [Common Error Messages](#common-error-messages)
- [References](#references)

## Vulnerability Overview

- **CVE ID**: [CVE-2024-51567](https://nvd.nist.gov/vuln/detail/CVE-2024-51567)
- **Vulnerability Type**: Command Injection / CSRF Bypass
- **Affected Software**: CyberPanel through versions 2.3.6 and 2.3.7 (unpatched)
- **Description**: The `upgrademysqlstatus` endpoint in `databases/views.py` of CyberPanel (prior to commit `5b08cd6`) allows remote attackers to execute arbitrary commands by bypassing `secMiddleware` protections, which only filter POST requests. This vulnerability can be exploited using shell metacharacters in the `statusfile` parameter.
- **Exploitation in the Wild**: Exploited by PSAUX in October 2024.

## Features
- Retrieves the CSRF token from the target server to authenticate requests
- Creates and sends a specially crafted payload to bypass CSRF protections
- Executes remote commands on a vulnerable CyberPanel server through the `/dataBases/upgrademysqlstatus` endpoint
- Supports exploitation of both **single** and **multiple** targets
- Interactive command execution mode, allowing repeated command input until the user exits
- Provides an error message if the CSRF token is missing or invalid

## Prerequisites
- Python 3
- `httpx` module

## Installation
1. **Clone the repository**:
   ```bash
   git clone https://github.com/ajayalf/CVE-2024-51567.git
   cd CVE-2024-51567
   ```
2. **Install dependencies**:
   Ensure `httpx` is installed:
   ```bash
   pip install httpx
   ```

## Usage

### Single Target
To run the script on a single target, use the following command:
```bash
python CVE-2024-51567.py <target-url>
```
Example:
```bash
python CVE-2024-51567.py http://example.com
```

### Multiple Targets
To run the script on multiple targets, create a text file with a list of target URLs (one URL per line), and use the command:
```bash
python CVE-2024-51567.py <targets.txt>
```
Example:
```bash
python CVE-2024-51567.py targets.txt
```

### Example: Multiple Targets
If you want to use multiple targets, create a text file named `targets.txt` or any preferred name. The format of the file should be a list of URLs, with one URL per line, as shown below:

```
http://target1.com
http://target2.com
http://target3.com
```

### Sample Output
After the script connects to a target, you can enter shell commands to execute on the target server. To exit, type `exit` or `quit`.

## Code Structure

- **get_CSRF_token(client)**: Retrieves the CSRF token from cookies on the target's main page.
  - *Input*: `client` (an `httpx.Client` object)
  - *Output*: The CSRF token value, or an error if not found.

- **pwn(client, CSRF_token, cmd)**: Sends a crafted payload with the CSRF token and the desired command.
  - *Input*: `client` (an `httpx.Client` object), `CSRF_token` (string), `cmd` (string)
  - *Output*: Status of the request or "Error".

- **exploit(client, cmd)**: Executes the `pwn` function on the target to run the command and prints the output.
  - *Input*: `client` (an `httpx.Client` object), `cmd` (string)

- **run_exploit(target)**: Initializes a connection to the target and starts an interactive command loop.
  - *Input*: `target` (string, target URL)
  - *Process*: Receives user commands until the user types `exit` or `quit`.

- **Main Execution**: Checks the argument to determine if the target is a single URL or a file with multiple targets.
  - If a file is provided, it reads and executes on each target in the list.
  - If a URL is provided, it runs a single target.

## Error Handling and Debugging

If the CSRF token is not found in the cookies, the script will print all received cookies and exit with a helpful error message.

### Common Error Messages
- **"Error: CSRF token not found in cookies."**: This indicates that the CSRF token was not found in the response cookies from the target server. Solutions:
  - Verify that the server sends a CSRF token in the cookies.
  - Ensure that `/` is the correct endpoint for obtaining the CSRF token. If it is different, modify the function `get_CSRF_token` accordingly.

## References
For further information regarding this vulnerability, please refer to the following resources:
- [CVE-2024-51567 on NVD](https://nvd.nist.gov/vuln/detail/CVE-2024-51567)
- [Remote Code Execution Vulnerability in CyberPanel by Ionix](https://www.ionix.io/blog/remote-code-execution-vulnerability-in-cyberpanel/)
- [What Are My Options? CyberPanel v2.3.6 Pre-Auth RCE by Dreyand](https://dreyand.rs/code/review/2024/10/27/what-are-my-options-cyberpanel-v236-pre-auth-rce)
