## Description

CVE-2024-51442 is a command injection vulnerability in minidlna/Readyshare version <= 1.3.3. This vulnerability can be exploited by running minidlnad with a specially crafter db_dir parameter used in minidlna.conf.

## Vulnerability

The vulnerability exists both in  in the `rescan` functionality of the `check_db` function

minidlna.c
```c
rescan:

		CLEARFLAG(RESCAN_MASK);

		if (ret < 0)

			DPRINTF(E_WARN, L_GENERAL, "Creating new database at %s/files.db\n", db_path);

		else if (ret == 1)

			DPRINTF(E_WARN, L_GENERAL, "New media_dir detected; rebuilding...\n");

		else if (ret == 2)

			DPRINTF(E_WARN, L_GENERAL, "Removed media_dir detected; rebuilding...\n");

		else

			DPRINTF(E_WARN, L_GENERAL, "Database version mismatch (%d => %d); need to recreate...\n",

				ret, DB_VERSION);

		sqlite3_close(db);

		snprintf(cmd, sizeof(cmd), "rm -rf %s/files.db %s/art_cache", db_path, db_path);

		if (system(cmd) != 0)

			DPRINTF(E_FATAL, L_GENERAL, "Failed to clean old file cache!  Exiting...\n");
```


and when `-R` is passed as an optional command line parameter:

minidlna.c
```c
case 'R':

			snprintf(buf, sizeof(buf), "rm -rf %s/files.db %s/art_cache", db_path, db_path);

			if (system(buf) != 0)

				DPRINTF(E_FATAL, L_GENERAL, "Failed to clean old file cache %s. EXITING\n", db_path);

			break;
```

The above code will run `"rm -rf %s/files.db %s/art_cache` with `db_path` as a parameter to the format string. `db_path` is picked up from the configuration file when processed by the code in `options.c` .

## Exploitation

This vulnerability can be exploited by using the example `minidlna.conf` in this repository as the configuration file. This will open a file system window using `xdg-open` as a proof of concept.

```bash
minidlnad -d -f minidlna.conf
```
