# CyberPanel Command Injection Vulnerability - CVE-2024-51378

**Exploit for CyberPanel Pre-Auth RCE (Remote Code Execution) via Command Injection**  
**Author:** [Luka Petrovic (refr4g)](https://refr4g.github.io/about/)  
**Date Disclosed:** October 2024

## Overview

Proof-of-concept (PoC) exploit for a command injection vulnerability (CVE-2024-51378) in CyberPanel. This vulnerability enables unauthenticated attackers to inject and execute arbitrary commands on vulnerable servers by sending crafted OPTIONS HTTP requests to `/dns/getresetstatus` and `/ftp/getresetstatus` endpoints, potentially leading to full system compromise.
### Impact

An attacker with network access to the CyberPanel interface can use this vulnerability to gain full control over the affected system.

## Exploit Details

-   **Vulnerable Versions**: CyberPanel v2.3.5, v2.3.6, v.2.3.7 (before patch)
-   **Exploitation Method**: Command injection via crafted requests to /dns/getresetstatus and /ftp/getresetstatus CyberPanel endpoints.
-   **Requirements**: Network access to the CyberPanel interface.

## Usage

1. Clone the repository:
    ```bash
    git clone https://github.com/refr4g/CVE-2024-51378.git
    ```
2. Navigate to the directory:
    ```bash
    cd CVE-2024-51378
    ```
3. Execute the script, specifying the target URL and endpoint:
    ```bash
    python3 CVE-2024-51378.py <target_url> <endpoint>
    ```
    - **`target_url`**: The URL of the CyberPanel instance (e.g., `http://target.com:8090`).
    - **`endpoint`**: The vulnerable endpoint (`/ftp/getresetstatus` or `/dns/getresetstatus`).

### Example

```bash
python3 CVE-2024-51378.py http://target.com:8090 /ftp/getresetstatus
```

## PoC Video

[![PoC Video](https://img.youtube.com/vi/EfTn1BeyAig/0.jpg)](https://www.youtube.com/watch?v=EfTn1BeyAig)

## Disclaimer

This code is for educational purposes only and should only be used on systems for which you have explicit permission to test.

## References

-   [Detailed Blog Post](https://refr4g.github.io/posts/cyberpanel-command-injection-vulnerability/)
-   [NVD NIST](https://nvd.nist.gov/vuln/detail/CVE-2024-51378)
