#!/usr/bin/python3

import sys
import random
import getopt
import os
from threading import Thread, Event
from tlslite.x509 import X509
from tlslite.utils.cryptomath import divceil
from tlsfuzzer.utils.log import Log
from tlsfuzzer.utils.progress_report import progress_report

import argparse


parser = argparse.ArgumentParser(prog='gen_timing_probes', description='What the program does', epilog='Text at the bottom of help')
                    
parser.add_argument('-c', action='append')
parser.add_argument('-o')
parser.add_argument('-r')

args = parser.parse_args()
characters = args.c


if sys.version_info < (3, 7):
    print("This script is compatible with Python 3.7 and later only")
    sys.exit(1)

def gen_timing_probes(out_dir, passw, args, repeat, verbose=False):
    probes = {}
    probe_names = []
    
    for i, probe_name in enumerate(passw):
        probes[probe_name] = passw[i] #probe_name?
        probe_names.append(probe_name)
        print(probes)

    # create an order in which we will write the ciphertexts in
    log = Log(os.path.join(out_dir, "log.csv"))

    log.start_log(probes.keys())

    for _ in range(repeat):
        log.shuffle_new_run()

    log.write()

    # reset the log position
    log.read_log()

    try:
        # start progress reporting
        status = [0, len(probe_names) * repeat, Event()]
        if verbose:
            kwargs = {}
            kwargs['unit'] = ' ciphertext'
            kwargs['delay'] = 2
            progress = Thread(target=progress_report, args=(status,), kwargs=kwargs)
            progress.start()
            
    finally:
        if verbose:
            status[2].set()
            progress.join()
            print()

    print("done")



if __name__ == '__main__':
    cert = None
    out_dir = args.o
    force_dir = False
    verbose = False
    repeat = int(args.r, 10)

    try:
        os.mkdir(out_dir)
    except FileExistsError:
        pass
    
    gen_timing_probes(out_dir, characters, args, repeat, verbose)
