# CVE-2024-50677 | Two-Click Reflected XSS in OroPlatform CMS v5.1
This repository presents a proof-of-concept of CVE-2024-50677

## Disclaimer:
This code is a proof of concept of the vulnerability. I will not be held responsible for any use of this exploit.

## Description:
CVE-2024-50677 refers to a two-click reflected XSS that is present in default configurations of OroPlatform CMS v5.1, specifically the Demo platform here: https://github.com/oroinc/docker-demo

The vulnerability lies within how the application controls user input to the search function, if a user clicks on the search bar in the webpage's UI that has javascript as a query such as

```
<script>alert(1)</script>
```

The application will then load and execute this javascript freely.

This CVE was discovered by @ZumiYumi

## POC:
1. Attacker crafts a payload:
```
http://vulnerable-website/product/search?search=%3Cscript%3Ealert(1)%3C%2Fscript

```
2. Attacker phishes a user to click it.
3. Victim clicks on the search bar, or chained with another vulnerability to click the search bar.
4. Javascript executes.


## Versions Concerned:
* OroPlatform CMS v5.1

## References:
https://www.cve.org/CVERecord?id=CVE-2024-50677

https://nvd.nist.gov/vuln/detail/CVE-2024-50677

https://medium.com/@zumiyumi/how-i-discovered-my-first-cve-7b1e2987326c

