import sys

from loguru import logger


def set_logger(verbose: bool) -> None:
    logger.remove()
    logger.add(sys.stderr, format=formatter, level="DEBUG" if verbose else "INFO")


def formatter(record: dict) -> str:
    indicator = record["extra"]["indicator"]
    tag = record["extra"]["tag"]
    color = record["extra"].get("color", "white")
    message = record["message"]

    record["extra"]["log_message"] = f"{message}"
    return f"<{color}><bold>[{indicator}] {tag}</bold></{color}> {{extra[log_message]}}\n"


def info(tag: str, text: str) -> None:
    logger.bind(indicator="*", tag=tag, color="blue").info(text)


def success(tag: str, text: str) -> None:
    logger.bind(indicator="+", tag=tag, color="green").success(text)


def error(tag: str, text: str) -> None:
    logger.bind(indicator="-", tag=tag, color="red").error(text)


def debug(tag: str, text: str) -> None:
    logger.bind(indicator="~", tag=tag, color="yellow").debug(text)
