# Fortinet SSL-VPN Session Reuse Vulnerability (CVE-2024-50562)

![Python](https://img.shields.io/badge/python-3.8%2B-blue)
![license](https://img.shields.io/badge/license-MIT-green)

> **Professional, permission-only scanner** that proves whether a FortiGate
> invalidates session cookies after logout.  
> A positive finding confirms **CVE-2024-50562** — an **Insufficient Session
> Expiration** flaw (CWE-613) that lets an attacker replay a stolen cookie and
> log back in even after the user has explicitly logged out.

**Official advisory:** <https://fortiguard.com/psirt/FG-IR-24-339>

---

## 0 | Executive summary

> *“An Insufficient Session Expiration vulnerability \[CWE-613] in FortiOS
> SSL-VPN may allow an attacker in possession of a cookie used to log in to the
> SSL-VPN portal to log in again, although the session has expired or was
> logged out.”* — Fortinet PSIRT

|  |  |
|---|---|
| **IR Number** | FG-IR-24-339 |
| **Published** | **Jun 10 2025** |
| **Component** | SSL-VPN |
| **Severity** | Medium |
| **CVSS v3**  | 4.4 |
| **Impact**   | Improper access control |
| **CWE**      | 613 (Insufficient Session Expiration) |
| **CVE**      | **CVE-2024-50562** |
| **Affected mode** | *Web/portal* mode only — **Tunnel mode is **not** affected** |

### Acknowledgements

Fortinet credits:

* **Vang3lis & Cyth** – VARAS@IIE  
* **Shahid Parvez Hakim** – CEO & Founder, BugB Technologies (bugb.io)

### Timeline

| Date | Event |
|------|-------|
| 2025-06-10 | Initial public advisory (FG-IR-24-339) |

---

## 1 | Affected & fixed versions

| Product/Branch | Affected versions | First fixed |
|----------------|------------------|-------------|
| **FortiOS 7.6** | 7.6.0 | **7.6.1** |
| **FortiOS 7.4** | 7.4.0 – 7.4.7 | **7.4.8** |
| **FortiOS 7.2** | 7.2.0 – 7.2.10 | **7.2.11** |
| **FortiOS 7.0** | **all** | migrate to a fixed branch |
| **FortiOS 6.4** | **all** | migrate to a fixed branch |
| **FortiSASE 24.4** | 24.4.b | **24.4.c** (auto-remediated) |

> **Upgrade path helper:** <https://docs.fortinet.com/upgrade-tool>

---

## 2 | How this scanner validates the bug

1. **Login** to `/remote/logincheck` using test creds.  
2. **Capture** cookies (`SVPNCOOKIE`, `SVPNTMPCOOKIE`).  
3. **Logout** via `/remote/logout`.  
4. **Replay** captured cookies in a fresh session requesting `/sslvpn/portal.html`.  
5. **Verdict**  
   * Portal still loads → **REUSED** → *Vulnerable*  
   * Redirects to `/remote/login` → **INVALIDATED** → *Patched*

Console output is mirrored to a CSV for reporting.

---

## 3 | Quick start

```bash
# Clone repository
git clone https://github.com/Shahid-BugB/fortinet-cve-2024-50562.git
cd fortinet-cve-2024-50562

# Install dependency
pip install requests     # only third-party lib needed

# Create a targets file
cat > targets.txt <<'EOF'
192.168.2.3:4433
192.168.2.44:4433
# default port example
192.168.2.44
EOF

# Run the scan
python3 fortinet-cve-2024-50562-new.py \
        -f targets.txt \
        -u alice \
        -p 'alice@!123'
````

---

## 4 | CLI reference

```
usage: fortinet-cve-2024-50562-new.py [-h] -u USERNAME -p PASSWORD
                                      [-r REALM]
                                      [-t HOST[:PORT]] [-f FILE]
                                      [-o OUTPUT]
```

| Flag               | Purpose                                                                    | Example                |
| ------------------ | -------------------------------------------------------------------------- | ---------------------- |
| `-u`, `--username` | VPN username **(required)**                                                | `-u audit`             |
| `-p`, `--password` | VPN password **(required)**                                                | `-p 'Pa$$w0rd!'`       |
| `-r`, `--realm`    | Realm / auth domain (optional)                                             | `-r employees`         |
| `-t`, `--target`   | Single `host[:port]` (repeatable). Default `443`.                          | `-t 192.168.2.24:8443` |
| `-f`, `--file`     | File with one `host[:port]` per line (blank lines & `#` comments ignored). | `-f targets.txt`       |
| `-o`, `--output`   | CSV path (default `fortinet_reuse_results.csv`).                           | `-o scan.csv`          |

---

## 5 | CSV fields explained

| Column                 | Description                                                                        |
| ---------------------- | ---------------------------------------------------------------------------------- |
| `ip`, `port`           | Target gateway                                                                     |
| `login_success`        | `True` if creds worked                                                             |
| `vulnerability_status` | `REUSED` = **vulnerable** • `INVALIDATED` = secure • `auth-failed` = bad creds/MFA |
| `cookies_*`            | JSON-encoded cookie dicts (forensics)                                              |
| `summary`              | Duplicate of status for quick filters                                              |

---

## 6 | Remediation checklist

1. **Upgrade** to the fixed FortiOS/FortiSASE release.
2. **Mandate MFA** on all SSL-VPN accounts.
3. **Reduce idle/session timeouts** where feasible.
4. **Rotate credentials** if compromise is suspected.
5. **Monitor logs** for `/remote/login` & `/sslvpn/portal.html` from unfamiliar IPs.

---

## 7 | Legal & ethical use

This tool is provided **solely for authorised security assessments**.
Running it against systems without written permission may violate local law
(e.g., IT Act 2000, CFAA) and organisational policy.
The authors accept **no liability** for misuse.

---

## 8 | Credits & licence

- *Authors* — Security Team, **BugB Technologies**
- *Website* - https://www.bugb.io
- *Licence* — MIT

Pull requests & issues are warmly welcomed!

