# CVE-2024-50379 Exploitation and POC

This repository contains a Proof of Concept (POC) for **CVE-2024-50379**, a vulnerability affecting Apache Tomcat. The issue involves a **Time-of-Check Time-of-Use (TOCTOU) race condition**, which can lead to **Remote Code Execution (RCE)**, especially on case-insensitive file systems like Windows.

---

## Table of Contents

- [Description](#description)
- [POC](#poc)
- [Usage](#usage)
- [Security Considerations](#security-considerations)
- [License](#license)

---

## Description

CVE-2024-50379 is a vulnerability in Apache Tomcat that allows attackers to execute arbitrary code through a TOCTOU race condition. On case-insensitive file systems (e.g., Windows or macOS) and improperly configured servlets, this issue can be exploited.

---

## POC

### Overview

The POC demonstrates the exploitation of CVE-2024-50379 by uploading a malicious JSP file that can replace existing files with a different case (`FILE.JSP` overwriting `file.jsp`) in a Windows-based environment.

## POC Video

Download and play the [POC.mp4](POC.mp4) file from the repository.

### Steps:

1. **File Upload Exploit**:
    - On a Windows server, upload a JSP file (`file.jsp`).
    - Quickly replace it with a differently-cased file (`FILE.JSP`).
    - Due to the case-insensitive nature, the older file (`file.jsp`) will be overwritten.

2. **Changes in `web.xml`**:
    - Misconfigured permissions in `web.xml` can enable write access for the Default Servlet, making the exploitation possible.


## Usage

1. Deploy Apache Tomcat server.
2. Configure the Default Servlet with write permissions.
3. Use the provided POC to upload JSP files and exploit the TOCTOU race condition.

---

## Security Considerations

- This POC is for educational purposes only.
- **DO NOT USE** this in production without strict security measures.
- Ensure proper configuration of servlets and file systems to mitigate similar vulnerabilities.

---

## Blog

For more insights into **CVE-2024-50379**, check out my detailed blog:  
[Deep Dive & POC of CVE-2024-50379 in Apache Tomcat](https://medium.com/@patelvidhi4288/deep-dive-poc-of-cve-2024-50379-exploit-tomcat-vulnerability-9-8-severity-776cfcfcf3ed)

---


## License

This repository is provided under the [MIT License](LICENSE).
