# CVE-2024-4947

A in-the-wild V8 type confusion bug.

This repository contains
- Analysis and PoCs to escalate this vulnerability to have the same exploit pattern as CVE-2024-12695, Object Hash Reassign.
- AddressOf / FakeObject Primitives constructed by using the type confusion to assign object hash to `JSArray`'s `length` field and its analysis.

Analysis: [Analysis.md](Analysis.md)

## Reproduce Information

- OS: Ubuntu 24.04
- Git Commit: [12.4.254.16](https://chromium.googlesource.com/v8/v8/+/refs/tags/12.4.254.16)

## Acknowledgement

- Shoutout to [Vasily Berdnikov @vaber_b](https://twitter.com/vaber_b) and [Boris Larin @oct0xor](https://twitter.com/oct0xor) for finding the bug.
- Shoutout to [@buptsb](https://x.com/buptsb) and [@mistymntncop](https://x.com/mistymntncop) for writing a detailed analysis about this bug, which offers precious experience to facilitate research on this bug.
- Shoutout to 303f06e3 and [Dimitri Fourny @DimitriFourny](https://x.com/DimitriFourny) for revealing the brand new exploit pattern, *Object Hash Reassign*.
- Shoutout to [@mistymntncop](https://x.com/mistymntncop) for providing a reference to Kaspersky official writeup [The Crypto Game of Lazarus APT: Investors vs. Zero-days](https://securelist.com/lazarus-apt-steals-crypto-with-a-tank-game/114282/).

## References

1. https://issues.chromium.org/issues/340221135
2. https://web.archive.org/web/20250426073331/https://buptsb.github.io/blog/post/CVE-2024-4947-%20v8%20incorrect%20AccessInfo%20for%20module%20namespace%20object%20causes%20Maglev%20type%20confusion.html
3. https://issues.chromium.org/issues/383647255
4. https://bugscale.ch/blog/dissecting-cve-2024-12695-exploiting-object-assign-in-v8/
5. https://securelist.com/lazarus-apt-steals-crypto-with-a-tank-game/114282/

## Disclaimer
This repository is intended solely for educational purposes and must not be used for any malicious activities.
