
# Proof of Concept (PoC) for CVE-2024-49379

This repository contains a Python-based Proof of Concept (PoC) for a critical vulnerability identified in UmbrelOS. The vulnerability allows for Cross-Site Scripting (XSS), which can escalate to Remote Code Execution (RCE) under specific conditions.

## Overview

- **CVE**: CVE-2024-49379
- **Severity**: Critical
- **Vulnerability Type**: Cross-Site Scripting (XSS) leading to Remote Code Execution (RCE)
- **Affected Software**: UmbrelOS versions prior to 1.2.2
- **Discoverer**: Peter Stöckli (@p-) and the GitHub Security Lab team

The issue was identified in the login functionality, specifically in how the `redirect` query parameter is handled. A malicious payload can be injected, allowing unauthorized JavaScript execution in the context of a user's session.

## Details

The vulnerability exists due to improper input validation and unchecked flows from the `redirect` query parameter into sensitive browser sink functions, such as `window.location.href`. This flaw permits an attacker to inject arbitrary JavaScript into a victim's session. Under certain conditions, this can be escalated to server-side command execution via the Umbrel terminal WebSocket interface.

### Key Exploitation Vector:
1. A victim is tricked into accessing a malicious link containing the crafted payload in the `redirect` parameter.
2. The payload executes upon login, enabling the attacker to access sensitive session data or perform further actions.

## Proof of Concept (PoC)

This repository includes a Python script (`poc.py`) to generate a malicious URL containing the exploit payload. The script is intended for educational and authorized security testing purposes only.

### Usage
1. Clone the repository:
   ```bash
   git clone https://github.com/your-org-or-username/CVE-2024-49379.git
   cd CVE-2024-49379
   ```

2. Run the script:
   ```bash
   python3 poc.py
   ```

3. Share the generated URL with a test environment to observe the impact of the vulnerability.

## Mitigation

The vulnerability has been patched in UmbrelOS version 1.2.2. All users are strongly advised to upgrade to the latest version. Additionally, secure coding practices, such as input validation and safe redirects, should be employed to prevent similar issues.

### Fixed Version:
- UmbrelOS 1.2.2

### Recommendations:
- Upgrade immediately to the patched version.
- Review all query parameter handling and validate inputs rigorously.
- Implement Content Security Policy (CSP) headers to mitigate XSS risks.

## Acknowledgments

- **Discovered By**: Peter Stöckli (@p-) and the GitHub Security Lab team
- **PoC Adapted for Python By**: S1REN

## Disclaimer

This PoC is provided for educational and authorized testing purposes only. Unauthorized use or distribution of this code may result in legal consequences. Always obtain explicit permission from the system owner before conducting any testing or vulnerability exploitation.

## License

This repository is released under the [MIT License](LICENSE). By using this repository, you agree to adhere to ethical guidelines and applicable laws.
