from logger import logger
from impacket.dcerpc.v5 import nrpc
from impacket.dcerpc.v5.rpcrt import DCERPCException
from impacket.dcerpc.v5.transport import DCERPCTransportFactory

NULL = '\x00'

def DsrGetDcNameEx2(target_ip: str, port: int, account: str, site_name: str, domain_name: str):
    # Build the RPC transport using ncacn_ip_tcp over <target_ip>:<port>
    rpctransport = DCERPCTransportFactory(f'ncacn_ip_tcp:{target_ip}[{port}]')
    dce = rpctransport.get_dce_rpc()
    dce.connect()
    logger.info(f"Connected to {target_ip}:{port}")
    
    try:
        dce.bind(nrpc.MSRPC_UUID_NRPC)
    except DCERPCException:
        logger.error("Failed to bind to NRPC interface!")
        logger.info("This might be because the target is doesn't have netlogon service running.")
        raise

    request = nrpc.DsrGetDcNameEx2()
    request['ComputerName']                = NULL
    request['AccountName']                 = account + NULL
    request['AllowableAccountControlBits'] = 1 << 9
    request['DomainName']                  = domain_name + NULL
    request['DomainGuid']                  = NULL
    request['SiteName']                    = site_name + NULL
    request['Flags']                       = 0

    logger.info("Sending DsrGetDcNameEx2 request...")
    resp = dce.request(request)
    resp.dump()
    dce.disconnect()
