# LDAP Nightmare

An exploit for CVE-2024-49112 reported by Yuki Chen (@guhe120). A vulnerability in Windows Lightweight Directory Access Protocol (LDAP).

Created by SafeBreach Labs (published on January 1st 2025). For the full technical analysis of the vulnerability and how we managed to exploit it check out the blog post [**here**](https://www.safebreach.com/blog/ldapnightmare-safebreach-labs-publishes-first-proof-of-concept-exploit-for-cve-2024-49112/)

## Overview

CVE-2024-49112 is a critical vulnerability in Windows LDAP client that according to Microsoft allows remote code execution. This exploit leverages the vulnerability to crash target Windows Server systems by interacting with their Netlogon Remote Protocol (NRPC), and LDAP client.

## Demo

https://github.com/user-attachments/assets/1cbda4a9-943a-4e07-a95a-b20e45863ec3


## Setup

1. **Install Dependencies**:

   Ensure that all required Python packages are installed. You can install them using `pip` and the provided `requirements.txt` file:

   ```bash
   pip install -r requirements.txt
   ```

2. **Configure the Exploit**:

   - `target_ip`: IP address of the target machine.
   - `port`: TCP port for RPC communication (default: 49664).
   - `listen_port`: UDP port for the exploit server to listen on (default: 389). If not changed, the tool is required to be run with admin or root privileges
   - `domain_name`: A domain name on the internet that the attacker owns. This domain must have two DNS SRV records under it. (SRV records map a domain to a port and another domain):
     - _ldap._tcp.dc._msdcs.`domain_name` -> `listen_port` `attacker's machine hostname`
     - _ldap._tcp.default-first-site-name._sites.dc._msdcs.`domain_name` -> `listen_port` `attacker's machine hostname`
     - Note - `attacker's machine hostname` will work assuming the victim server can find the attacker machine by its hostname using NBNS. Instead of the attacker's hostname, this value can be replaced with a domain name on the internet that point towards the IP of a malicious LDAP server exploiting the vulnerability.
   - `account`: Account name parameter (default: Administrator).
   - `site_name`: Site name parameter (default: empty string).

## Usage

```bash
python LdapNightmare.py <target_ip> --domain-name <domain_name> [options]
```

**Example**:

```bash
python LdapNightmare.py 192.168.1.100 --domain-name example.com
```

## How It Works

1. **Starts the Exploit Server**:

   The script initiates an asynchronous LDAP server that listens for incoming connections on the specified UDP port.

2. **Invokes `DsrGetDcNameEx2`**:

   The script calls the `DsrGetDcNameEx2` function via the Netlogon Remote Protocol to trigger the victim server to send an LDAP query to the attacker.

3. **Triggers the Vulnerability**:

   By sending specially crafted response, the exploit triggers the CVE-2024-49112 vulnerability, causing the victim server to crash


## References

- [CVE-2024-49112 Details](https://nvd.nist.gov/vuln/detail/CVE-2024-49112)
- [Microsoft Security Advisory](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2024-49112)

## Authors - Or Yair & Shahak Morag

|          | Or Yair                                         | Shahak Morag                                                  |
|----------|-------------------------------------------------|---------------------------------------------------------------|
| LinkedIn | [Or Yair](https://www.linkedin.com/in/or-yair/) | [Shahak Morag](https://www.linkedin.com/in/shahak-morag-6bb51b142/) |
| Twitter  | [@oryair1999](https://twitter.com/oryair1999)   | [@shahakmo](https://x.com/shahakmo)             |
