#!/bin/bash

# Ensure the script is run as root
if [ "$(id -u)" != "0" ]; then
   echo "This script must be run as root" 1>&2
   exit 1
fi

# Add group for chroot
groupadd chroot

# Add users with home directories and specific shell
useradd -m -d /home/bob -g chroot -s /bin/bash bob
useradd -m -d /home/eve -g chroot -s /bin/bash eve

# Set passwords for users
echo "Setting sys password for bob:"
passwd bob
echo "Setting sys password for eve:"
passwd eve

# Create device nodes
mkdir -p /home/bob/dev/
cd /home/bob/dev/
mknod -m 666 null c 1 3
mknod -m 666 tty c 5 0
mknod -m 666 zero c 1 5
mknod -m 666 random c 1 8

# Copy necessary binaries
mkdir -p /home/bob/bin
cp -v /bin/{bash,ls,ln,rm,mkdir} /home/bob/bin/

# Copy necessary libraries
mkdir -p /home/bob/lib /home/bob/lib64
cp -v /lib/x86_64-linux-gnu/{libc.so.6,libtinfo.so.6,libpcre2-8.so.0,libselinux.so.1} /home/bob/lib
cp -v /lib64/ld-linux-x86-64.so.2 /home/bob/lib64

# Copy system files
mkdir /home/bob/etc
cp -vf /etc/{passwd,group} /home/bob/etc/

# Replicate bob's environment for eve using rsync
rsync -av --exclude '.*' /home/bob/ /home/eve/

# Set ownership and permissions
chown root:root /home/bob /home/eve
mkdir /home/bob/home /home/eve/home
chown bob:chroot /home/bob/home
chown eve:chroot /home/eve/home
chmod 0755 -R /home/bob /home/eve

# Configure SSH to use chroot jails
echo 'Match Group chroot' >> /etc/ssh/sshd_config
echo 'ChrootDirectory %h' >> /etc/ssh/sshd_config
systemctl restart ssh
systemctl restart sshd

# Configure Pure-FTPd
echo "Setting sftp password for bob:"
pure-pw useradd bob -u bob -d /home/bob/home
echo "Setting sftp password for eve:"
pure-pw useradd eve -u eve -d /home/eve/home
pure-pw mkdb

echo "Setup complete."